﻿#region usings
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;

#endregion usings

namespace VVVV.Nodes
{
    #region PluginInfo
	[PluginInfo(Name = "VertexInfo", Category = "2d.Voronoi", Help = "Returns voronoi vertex information", Tags = "Voronoi, Delaunay")]
    #endregion PluginInfo
    public class VertexInfo : IPluginEvaluate
    {
        #region fields & pins
        [Input("Vertex")]
		public IDiffSpread<FortuneVertex> Vertex;

	    [Input("Convert Rays", DefaultBoolean = true)]
		public IDiffSpread<bool> FRayProcess;

	    [Input("Start")]
		public IDiffSpread<FortuneVertex> Start;

	    [Input("Infinite Ray Multiplier", DefaultValue = 100.0)]
		public IDiffSpread<double> RayMult;

		[Output("Location")]
		public ISpread<double> Location;

        [Output("Is at Infinity")]
		public ISpread<bool> FAtInfinity;

        [Output("Cells")]
		public ISpread<FortunePoly> Cells;

        [Output("Edges")]
		public ISpread<FortuneEdge> Edges;

        [Output("Bin Size")]
		public ISpread<int> BinSizes;
        #endregion fields & pins

        //called when data for any output pin is requested
        public void Evaluate(int spreadMax)
        {
	        if (!Vertex.IsChanged && !FRayProcess.IsChanged && !Start.IsChanged && !RayMult.IsChanged)
	        {
		        return;
	        }
            Location.SliceCount = spreadMax * 2;
            FAtInfinity.SliceCount = spreadMax;
	        Location.SliceCount =
		        FAtInfinity.SliceCount =
			    Cells.SliceCount =
				Edges.SliceCount = 
				BinSizes.SliceCount = 0;

            for (var ivtx = 0; ivtx < spreadMax; ivtx++)
            {
                var vertex = Vertex[ivtx];
	            if (vertex == null)
	            {
		            continue;
	            }
	            if (vertex.FAtInfinity && FRayProcess[ivtx])
	            {
		            var output = Start[ivtx].Pt;
		            var rayMult = RayMult[ivtx];
					output.X += rayMult * vertex.Pt.X;
					output.Y += rayMult * vertex.Pt.Y;
		            Location.Add(output.X);
					Location.Add(output.Y);
				}
	            else
	            {
					Location.Add(vertex.Pt.X);
					Location.Add(vertex.Pt.Y);
				}
                FAtInfinity.Add(vertex.FAtInfinity);
                var cCellsEdges = 0;
                foreach (var wePolygon in vertex.Polygons)
                {
                    cCellsEdges++;
                    Cells.Add(wePolygon as FortunePoly);
                }
                BinSizes.Add(cCellsEdges);
                foreach (var weEdge in vertex.FortuneEdges)
                {
                    Edges.Add(weEdge);
                }
            }
        }
    }
}
