﻿#region usings
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Vertices", Category = "2d.Voronoi", Help = "Returns voronoi Vertices", Tags = "Voronoi, Delaunay")]
	#endregion PluginInfo
	public class Vertices : IPluginEvaluate
	{
		#region fields & pins
		[Input("Voronoi Complex")]
		public IDiffSpread<WingedEdge<FortunePoly, FortuneEdge, FortuneVertex>> ComplexIn;

		[Input("Include Vertices at Infinity", DefaultBoolean = false)]
		public IDiffSpread<bool> FIncludeInfinite;

		[Output("Vertices")]
		public ISpread<FortuneVertex> VerticesSprd;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int spreadMax)
		{
			if (!ComplexIn.IsChanged && !FIncludeInfinite.IsChanged)
			{
				return;
			}
			var complexIn = ComplexIn[0];
			if (complexIn == null)
			{
				return;
			}
		    var fIncludeInfinite = FIncludeInfinite[0];

			VerticesSprd.SliceCount = complexIn.LstPolygons.Count;
			for (var ivtx = 0; ivtx < complexIn.LstEdges.Count; ivtx++)
			{
			    var vertex = complexIn.LstVertices[ivtx];
				if (fIncludeInfinite || !vertex.FAtInfinity)
				{
					VerticesSprd[ivtx] = vertex;
				}
			}
		}
	}
}