
const galleryContainer = document.querySelector('.react-gallery');

class GalleryPreview extends React.Component {
  render() {
    return React.createElement('img', { className: this.props.className, src: this.props.src, alt: '', style: { cursor: "pointer" } });
  }
}

class GalleryModal extends React.Component {
  constructor(props) {
    super(props);

    this.state = { email: '' };

    this.handleChange = this.handleChange.bind(this);
    this.handleSubmit = this.handleSubmit.bind(this);
    this.closeModal = this.closeModal.bind(this);
  }

  render() {
    if (this.props.isOpen === false) {
      return null;
    }

    let view;
    if (this.props.selectedItem.type == "video") {
      view = React.createElement('video', { poster: this.props.selectedItem.preview, autoPlay: 'autoplay', loop: 'loop', src: this.props.selectedItem.original, style: { maxWidth: '100%' }, onClick: this.stopClickEvent });
    }
    if (this.props.selectedItem.type == "image") {
      view = React.createElement('img', { src: this.props.selectedItem.original, style: { maxWidth: '100%' }, onClick: this.stopClickEvent });
    }

    return React.createElement(
      'div',
      { className: 'modal-overlay', name: this.props.name, onClick: this.closeModal },
      React.createElement(
        'div',
        { className: 'modal-body', onClick: function (e) {
            e.stopPropagation();e.nativeEvent.stopImmediatePropagation();
          } },
        React.createElement(
          'a',
          { className: 'modal-close', href: '#', onClick: this.closeModal, style: { zIndex: 1 } },
          React.createElement('span', { className: 'glyphicon glyphicon-remove' })
        ),
        view,
        React.createElement(
          'div',
          { style: { backgroundColor: 'white', padding: 10 }, onClick: this.stopClckEvent },
          React.createElement(
            'form',
            { className: 'form-inline', onSubmit: this.handleSubmit },
            React.createElement(
              'div',
              { className: 'form-group', style: { display: 'flex', flexDirection: 'row' }, onClick: this.stopClckEvent },
              React.createElement(
                'label',
                { htmlFor: 'exampleInputEmail2', style: { margin: '10px', lineHeight: '30px' } },
                'Email'
              ),
              React.createElement('input', { type: 'email', className: 'form-control', id: 'exampleInputEmail2', style: { width: '100%', margin: '10px' }, value: this.state.email, onChange: this.handleChange, onClick: this.stopClckEvent }),
              React.createElement(
                'button',
                { type: 'submit', style: { margin: '10px' }, className: 'btn btn-default' },
                'Send'
              )
            )
          )
        )
      )
    );
  }

  closeModal(e) {
    this.setState({ email: '' });
    this.props.onClick(e);
  }

  stopClickEvent(e) {
    e.stopPropagation();
    e.nativeEvent.stopImmediatePropagation();
  }

  handleChange(event) {
    this.setState({ email: event.target.value });
  }

  handleSubmit(event) {
    if (this.state.email.length > 0) this.props.socket.send(JSON.stringify({ file: this.props.selectedItem.file, email: this.state.email }));

    this.closeModal();
    event.preventDefault();
  }
}

class Gallery extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      socket: null,
      galleryItems: [],
      showModal: false,
      selectedItem: null
    };

    this.openModal = this.openModal.bind(this);
    this.closeModal = this.closeModal.bind(this);
    this.openWebSocket = this.openWebSocket.bind(this);

    this.openWebSocket();
  }

  render() {
    if (this.state.galleryItems.length == 0) {
      return React.createElement(
        'div',
        { refs: 'gallery-container', className: 'container-fluid gallery-container' },
        React.createElement(
          'div',
          { className: 'row' },
          React.createElement(
            'div',
            { className: 'alert alert-warning', role: 'alert' },
            'There is no items.'
          )
        )
      );
    }
    return React.createElement(
      'div',
      { refs: 'gallery-container', className: 'container-fluid gallery-container' },
      React.createElement(
        'div',
        { className: 'row' },
        this.state.galleryItems.map((item, index) => {
          return React.createElement(
            'div',
            { key: index, className: 'col-sm-6 col-md-3 col-xl-2' },
            React.createElement(
              'div',
              { className: 'gallery-card', onClick: e => this.openModal(item, e) },
              React.createElement(GalleryPreview, { className: 'gallery-thumbnail', src: item.preview, alt: '' })
            )
          );
        })
      ),
      React.createElement(GalleryModal, { socket: this.state.socket, isOpen: this.state.showModal, onClick: this.closeModal, selectedItem: this.state.selectedItem })
    );
  }

  openModal(item, e) {
    this.setState({
      showModal: true,
      selectedItem: item
    });
  }

  closeModal(e) {
    this.setState({
      showModal: false,
      selectedItem: null
    });
  }

  openWebSocket() {
    let that = this;

    var socket = new WebSocket("ws://%myip%:8006");

    socket.onopen = function () {
      console.log("connection opened");
      that.setState({ socket: socket });
    };

    socket.onclose = function (event) {
      if (event.wasClean) {
        console.log('connection closed properly');
      } else {
        console.log('connection error');
      }
      console.log('Code: ' + event.code + ' reason: ' + event.reason);

      that.setState({ socket: null });
      console.log('reconnect in 5 sec');
      setTimeout(that.openWebSocket, 5000);
    };

    socket.onmessage = function (event) {
      that.setState({ galleryItems: JSON.parse(event.data) });
    };

    socket.onerror = function (error) {
      console.log("Error " + error.message);
    };
  }
}

ReactDOM.render(React.createElement(Gallery, null), galleryContainer);