#region usings
using System;
using System.ComponentModel.Composition;
using System.Xml;
using System.Xml.XPath;
using System.IO;
using System.Text;
using System.Runtime.Serialization.Json;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "XPath", Category = "XML", Version = "Advanced", Help = "XPath advanced", Tags = "xml, xpath", Author="Zeos")]
	#endregion PluginInfo
	public class AdvancedStringXPathNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("XML", DefaultString = "<?xml version=\"1.0\" encoding=\"utf-8\"?>")]
		IDiffSpread<string> FXML;
		
		[Input("Expression", DefaultString = "count(//PATCH/NODE)")]
		IDiffSpread<string> FExpr;
		
		[Output("Output")]
		ISpread<ISpread<string>> FOutput;
		
		[Output("Status")]
		ISpread<ISpread<string>>FStatus;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if(FXML.IsChanged || FExpr.IsChanged) 
			{
				FOutput.SliceCount = 0;
				FStatus.SliceCount = 0;
				
				for(var j = 0; j<FXML.SliceCount; j++)
				{
					FOutput.SliceCount++;
					FStatus.SliceCount++;
					FStatus[j].SliceCount = 0;
					FOutput[j].SliceCount = 0;
					
					using (StringReader sr = new StringReader(FXML[j]))
					{
						try 
						{
							var doc = new XPathDocument(sr);
							var nav = doc.CreateNavigator();
						
							for (int i = 0; i < FExpr.SliceCount; i++) 
							{
								string query = FExpr[i];   
								string res = null;
								var expr = nav.Compile(query);
								
								//debug
								//FLogger.Log(LogType.Debug, "ReturnType: " + expr.ReturnType.ToString());
								
								
								//process
								switch (expr.ReturnType)
								{        
								    case XPathResultType.Number:
								       	
											double resNumber = (double)nav.Evaluate(query);
											res = resNumber.ToString();
								        
									break;
									
								    case XPathResultType.String:
								    // case XPathResultType.Navigator:
								        	res =  nav.Evaluate(query).ToString();
								    break;
								
								    case XPathResultType.Boolean:
								        res = nav.Evaluate(query).ToString();
								        break;
								
								    case XPathResultType.NodeSet:
										
								        var nodes = nav.Select(expr);
										
								       	if(nodes.Count>1)
										{
											
									        while (nodes.MoveNext())
									        {                      
									            if (nodes.Current == null) continue; //empty
									        	
									        	if(nodes.Current.HasChildren) 
									        	{
									        		
									        		var ni = nodes.Current.SelectChildren(XPathNodeType.Element);
									        		
									        		//FLogger.Log(LogType.Debug, nodes.Current.LocalName + " HasChildren: " + ni.Count.ToString() + "\n-----------------------------------\n");
									        	
									        		if(ni.Count>0)
									        			FOutput[j].Add(nodes.Current.OuterXml );
									        		else
									        			FOutput[j].Add(nodes.Current.InnerXml );
									        		
									        	}
									        	else 
									           	 	FOutput[j].Add(nodes.Current.InnerXml );
									        	
									        }
											FStatus[j].Add("OK");
											res = null;
								    	}
										else if(nodes.Count == 1)
										{
											//FLogger.Log(LogType.Debug, "Single:" + nodes.Current.LocalName + " count: " + nodes.Count.ToString());
											nodes.MoveNext();
											
											FOutput[j].Add(nodes.Current.InnerXml );
											FStatus[j].Add("OK");
										}
										else 
										{
											//FLogger.Log(LogType.Debug, "0:" + nodes.Current.LocalName + " count: " + nodes.Count.ToString());
											FOutput[j].Add(null);  //or return string.Empty ?
											FStatus[j].Add("Error"); //not found, xpath incorrect
										}
									
										continue;
									break;
								
								    case XPathResultType.Any:
											
								        res = null; //!!! 
										FLogger.Log(LogType.Debug, "XPathResultType.Any: " + res);
										
								        break;  
									
									case XPathResultType.Error:
										res = nav.ToString();
										break;
								
								    default:
								         res = nav.Evaluate(query).ToString();                    
								    break;
								}     
								
								if(res != null) 
								{
									FOutput[j].Add(res);
									FStatus[j].Add("OK");
								} 
								else 
								{
									FOutput[j].Add(null); //or return string.Empty ?
									FStatus[j].Add("Error");
									
								}
							}
						}
						catch (Exception e)
						{
						
								FOutput[j].Add(null); //or return string.Empty ?
								FStatus[j].Add("Error: " + e.Message);
						}
						
					}
					
				}
			}
		}
	}
}
