
struct CubeSphereVolume
{
float3 position;
float3 color;
};

StructuredBuffer<CubeSphereVolume> PositionColorIn;

	//For Tranform Function
#include "Transform.fxh"

    float3 Translate ={0,0,0};
	float3 Scale ={1,1,1};
	float3 Rotation = {0,0,0};
	float3 TranslateOffset = {0,0,0};

Texture2D texture2d; 

SamplerState g_samLinear : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	float4x4 tW : WORLD;
	
	int colorcount = 1;
};

struct VS_IN
{
	uint ii : SV_InstanceID;
	float4 PosO : POSITION;
	float2 TexCd : TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;	
	float4 Color: TEXCOORD0;
    float2 TexCd: TEXCOORD1;	
};

vs2ps VS(VS_IN input)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
	//Transform Function
    float4 Trans_0 = Transform3D(input.PosO,PositionColorIn[input.ii].position,Scale,Rotation,TranslateOffset);

	float4x4 MatrixIn = {Scale.x,0,0,0,  0,Scale.y,0,0,  0,0,Scale.z,0, PositionColorIn[input.ii].position,1} ;
	
	MatrixIn=mul(MatrixIn,tW);
    Out.PosWVP  = mul(input.PosO,mul(MatrixIn,tVP));
	Out.Color = float4(PositionColorIn[input.ii % colorcount].color,1);
    Out.TexCd = input.TexCd;
    return Out;
}

float4 PS_Tex(vs2ps In): SV_Target
{
    float4 col = texture2d.Sample( g_samLinear, In.TexCd) * In.Color;
    return col;
}

technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Tex() ) );
	}
}




