
#define TUBE_RES 8

#include "BSplineCubic.fxh"
#include "StageStructs.fxh"

float4x4 tWVP:WORLDVIEWPROJECTION;
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float4x4 tV:VIEW;
float4x4 tP:PROJECTION;
float4x4 tWI:WORLDINVERSE;
float4x4 tVI:VIEWINVERSE;
float4x4 tPI:PROJECTIONINVERSE;
float4x4 tWIT:WORLDINVERSETRANSPOSE;

Texture2D tex0 <string uiname="Texture";>;
SamplerState s0 <string uiname="Sampler";>
{Filter=MIN_MAG_MIP_LINEAR;AddressU=WRAP;AddressV=WRAP;};

//spline parameters
StructuredBuffer<float3> ControlPointBuffer;
//int VertexPerSpline=16;
//int ControlPointPerSpline=2;

//spline index, for each vertex to know what spline it belongs to
StructuredBuffer<uint>sbSplineID; 
StructuredBuffer<uint> sbControlBin;
StructuredBuffer<uint> sbControlOffset;

StructuredBuffer<uint> sbVertexBin;
StructuredBuffer<uint> sbVertexOffset;

bool Loop=0;
float TangentEpsilon=.01;
//float TesselationFactor <float uimin=1.0;float uimax=64.0;> = 1;
StructuredBuffer<uint> sbTesselationFactor;

//tape/tube geometry parameters
float3 UpVector={0,1,0};
float Radius=0.5;
StructuredBuffer<float>sbRadius;
int RadiusCount;
StructuredBuffer<float4x4>sbRing;
StructuredBuffer<float4x4>sbRingIT;
int RingTransformCount;

//texturing/coloring
float4 Color <bool color=true;> = {1.0,1.0,1.0,1.0};
StructuredBuffer<float4>sbColor;
int ColorCount=1;

StructuredBuffer<float4x4>sbTexTransform;
int TexTransformCount=1;

StructuredBuffer<float4x4>sbTransform;
int TransformCount=1;

float Distort=0;
float Phase=0;
float Frequency=2;




//SPLINE DISTORT FUNCTION

float3 dist(float3 pos,int splineid=0,float t=0){
	float3 p=pos;
	p=mul(float4(p.xyz,1),sbTransform[(uint)splineid%TransformCount]).xyz;
	//p.y+=sin(p.x*Frequency+Phase*acos(-1)*2)*.07*Distort;
	/*
	float f=splineid;
	
	for(int i=0;i<8;i++){
		float sz=pow(1.0,i)*1.8*Frequency;
		p+=sin(p.yzx*sz+Phase*acos(-1)*2)*Distort/pow(sz,1.)*pow(2,-3*length(sin(p.xyz*sz+Phase*acos(-1)*2)));
	}
	//*/
	return p;
}


//TESSELATION SETUP
VS_OUT VS(VS_IN In){VS_OUT p;p.iv=In.iv;return p;}
HSC_OUT HSConst(InputPatch<VS_OUT, 1> In){HSC_OUT Out;float TesselationFactor=sbTesselationFactor[sbSplineID[In[0].iv]];Out.edges[0]=1.0f;Out.edges[1]=TesselationFactor;return Out;}
[domain("isoline")][partitioning("fractional_even")][outputtopology("line")][outputcontrolpoints(1)][patchconstantfunc("HSConst")]
VS_OUT HS(InputPatch<VS_OUT, 1> ip, uint id : SV_OutputControlPointID){VS_OUT output;output.iv=ip[0].iv;return output;}


[domain("isoline")]
GS_IN DS(HSC_OUT hsc, OutputPatch<VS_OUT, 1> In, float2 uv : SV_DomainLocation)
{
    GS_IN Out;
	
	
	
	
	//Retrieve spline id and vertex id
	//int splineid = In[0].iv / VertexPerSpline;	
	//int segmentid = In[0].iv % VertexPerSpline;
	int splineid = sbSplineID[In[0].iv];
	int segmentid = In[0].iv-sbVertexOffset[splineid];
	
	int ControlPointPerSpline=sbControlBin[splineid];
	
	int VertexPerSpline=sbVertexBin[splineid];
	
	
	//That's the control point range in the buffer
	//int offset=splineid * ControlPointPerSpline;
	int offset=sbControlOffset[splineid];
	
	//int startctrl = splineid * ControlPointPerSpline;
	//int endctrl = startctrl + ControlPointPerSpline -1;
	int startctrl = 0;
	int endctrl = ControlPointPerSpline -1;
	
	//number between 0 and 1 generated by tesselator
	float t = uv.x;
	 
	//Rebuild with segment ids
	float segmentsize = 1.0f / (float)VertexPerSpline;
	t *= segmentsize;
	t += segmentsize * (float)segmentid;

	
	SplinePosTan3 sp=(SplinePosTan3)0;

	//That will be nearest control point
	//int t2 = floor(t*ControlPointPerSpline) + startctrl;
	
	int t2 = (t*ControlPointPerSpline);
	
	//Grab four control points around our coordinate
	float3 c1 = ControlPointBuffer[clamp(t2-1,startctrl,endctrl)+offset];
	float3 c2 = ControlPointBuffer[clamp(t2-0,startctrl,endctrl)+offset];
	float3 c3 = ControlPointBuffer[clamp(t2+1,startctrl,endctrl)+offset];
	float3 c4 = ControlPointBuffer[clamp(t2+2,startctrl,endctrl)+offset];
	//Compute spline equation (which has derivative for normal and other bits)
	sp = BSplineCubic3PT(c1,c2,c3,c4,t*ControlPointPerSpline);
	
	
	if(Loop){
	t2+=ControlPointPerSpline;
	float3 c1 = ControlPointBuffer[(t2-1)%(uint)ControlPointPerSpline+offset];
	float3 c2 = ControlPointBuffer[(t2-0)%(uint)ControlPointPerSpline+offset];
	float3 c3 = ControlPointBuffer[(t2+1)%(uint)ControlPointPerSpline+offset];
	float3 c4 = ControlPointBuffer[(t2+2)%(uint)ControlPointPerSpline+offset];
	sp = BSplineCubic3PT(c1,c2,c3,c4,t*ControlPointPerSpline);
	}
	
	float3 p=sp.Pos.xyz;
	
	sp.Pos.xyz=dist(sp.Pos.xyz,splineid,t);
	sp.Tang.xyz=dist(p+normalize(sp.Tang)*TangentEpsilon,splineid,t)-sp.Pos.xyz;
	
    Out.Pos =sp.Pos.xyz;
	Out.Dir = normalize(sp.Tang);
	Out.TexCd=float2(t,0);
	float TesselationFactor=sbTesselationFactor[sbSplineID[In[0].iv]];
	if(!Loop)Out.TexCd.y=t>segmentsize*(VertexPerSpline)*(1-0.25/(VertexPerSpline*TesselationFactor));
	Out.si=splineid;
	
    return Out;
}



void GS_TubePoint( float3x3 m, GS_IN In, int i,float2 TexCd, inout TriangleStream<PS_IN>GSOut)
{
	PS_IN Out;
	float4x4 tRing=sbRing[In.si%RingTransformCount];
	float4x4 tRingIT=sbRingIT[In.si%RingTransformCount];
	float fRad=Radius*sbRadius[In.si%RadiusCount];
	float3 ring=float3(sin(((float)i/TUBE_RES-.5/TUBE_RES+float2(-.25,0))*acos(-1)*2).xy,0);
	float3 pos = (mul(mul(float4(ring * fRad,1),tRing).xyz,m ));
	
	//float3 pos = (mul(mul(float4(TubeRes[i].xyz,1),tRing).xyz,m )) * fRad;
	//float3 norm = normalize(pos);
	float3 norm = normalize(mul(mul(float4(ring,1),tRingIT).xyz,m ));
	
	norm = mul(float4(norm,0),tWIT).xyz;
	pos += In.Pos;
	Out.PosWVP = mul( float4(pos,1), tWVP );
	Out.Norm = norm;
	Out.TexCd=TexCd;
	Out.si=In.si;
	GSOut.Append(Out);
}
//*
#define TUBE_RES_SQ 4
void GS_TubePointSQ( float3x3 m, GS_IN In, int i, int ni,float2 TexCd, inout TriangleStream<PS_IN>GSOut)
{
	PS_IN Out;
	float4x4 tRing=sbRing[In.si%RingTransformCount];
	float4x4 tRingIT=sbRingIT[In.si%RingTransformCount];
	float fRad=Radius*sbRadius[In.si%RadiusCount];
	float3 ring=float3(sin(((float)i/TUBE_RES_SQ-.5/TUBE_RES_SQ+float2(-.25,0))*acos(-1)*2).xy,0);
	float3 ring2=float3(sin(((float)(ni+0.5)/TUBE_RES_SQ+float2(-.25,0))*acos(-1)*2).xy,0);
	
	float3 pos = (mul(mul(float4(ring * fRad,1),tRing).xyz,m ));
	float3 norm = normalize(mul(mul(float4(ring2,1),tRingIT).xyz,m));
	norm = mul(float4(norm,0),tWIT).xyz;
	pos += In.Pos;
	Out.PosWVP = mul( float4(pos,1), tWVP );
	Out.Norm = norm;
	Out.TexCd=TexCd;
	Out.si=In.si;
	GSOut.Append(Out);
}
//*/
void GS_Point2D( float3x3 m, GS_IN In, float3 p,float2 TexCd, inout TriangleStream<PS_IN>GSOut)
{
	PS_IN Out;
	float4x4 tRing=sbRing[In.si%RingTransformCount];
	float4x4 tRingIT=sbRingIT[In.si%RingTransformCount];
	float fRad=Radius*sbRadius[In.si%RadiusCount];
	p=p* fRad;
	//p=mul(float4(p.xyz,1),transpose(tRingIT)).xyz;
	p=mul(float4(p.xyz,1),tRing).xyz;
	//fRad*=mul(float4(inpos.xyz,1),mul(tW,tV)).z;
	float3 pos = (mul(p,m ));
	
	float3 norm = normalize(pos);
	
	norm=mul(float4(norm,0),tWIT).xyz;
	pos += In.Pos;
	Out.PosWVP=mul(float4(pos,1),tWVP);
	Out.Norm=norm;
	Out.TexCd=TexCd;
	Out.si=In.si;
	GSOut.Append(Out);
}
float3x3 lookat(float3 dir,float3 up=float3(0,1,0)){float3 z=normalize(dir);float3 x=normalize(cross(up,z));float3 y=normalize(cross(z,x));return float3x3(x,y,z);} 

[maxvertexcount((TUBE_RES+1)*2)]
void gsTUBE(line GS_IN In[2], inout TriangleStream<PS_IN>GSOut){
	if(In[1].TexCd.y==1)return;
	float3 up=UpVector;
	//up=mul(float3(0,0,1),(float3x3)tVI);

	float3x3 m0=lookat(In[0].Dir,up);
	float3x3 m1=lookat(In[1].Dir,up);

	for(int i=0; i < TUBE_RES + 1; i++){
		GS_TubePoint( m0, In[0], i,float2(In[0].TexCd.x,(float)i/TUBE_RES), GSOut );
		GS_TubePoint( m1, In[1], i,float2(In[1].TexCd.x,(float)i/TUBE_RES), GSOut );
	}
	GSOut.RestartStrip();
}
//*

[maxvertexcount((TUBE_RES_SQ)*4)]
void gsTUBESQ(line GS_IN In[2], inout TriangleStream<PS_IN>GSOut){
	if(In[1].TexCd.y==1)return;
	float3 up=UpVector;
	//up=mul(float3(0,0,1),(float3x3)tVI);
	
	float3x3 m0=lookat(In[0].Dir,up);
	float3x3 m1=lookat(In[1].Dir,up);

    for(int i=0; i < TUBE_RES_SQ; i++){
		GS_TubePointSQ( m0, In[0], i,i,float2(In[0].TexCd.x,(float)i/TUBE_RES_SQ), GSOut );
		GS_TubePointSQ( m1, In[1], i,i,float2(In[1].TexCd.x,(float)i/TUBE_RES_SQ), GSOut );
		
		GS_TubePointSQ( m0, In[0], i+1,i,float2(In[0].TexCd.x,(float)(i+1)/TUBE_RES_SQ), GSOut );
    	GS_TubePointSQ( m1, In[1], i+1,i,float2(In[1].TexCd.x,(float)(i+1)/TUBE_RES_SQ), GSOut );
		GSOut.RestartStrip();
	}

	
    GSOut.RestartStrip();
}
//*/
[maxvertexcount(4)]
void gsTAPE(line GS_IN In[2], inout TriangleStream<PS_IN>GSOut){
	if(In[1].TexCd.y==1)return;
	float3 n0=normalize(mul(float4(In[0].Pos.xyz,1),tW).xyz-tVI[3].xyz);
	float3 n1=normalize(mul(float4(In[1].Pos.xyz,1),tW).xyz-tVI[3].xyz);
	//float3 n0=mul(float3(0,0,1),(float3x3)tVI);
	//float3 n1=mul(float3(0,0,1),(float3x3)tVI);

	float3x3 m0=lookat(In[0].Dir,n0);
	float3x3 m1=lookat(In[1].Dir,n1);
	
    float3 pos0 = In[0].Pos;
    float3 pos1 = In[1].Pos;

	GS_Point2D( m0, In[0], float3(-1,0,0),float2(In[0].TexCd.x,1), GSOut);
	GS_Point2D( m0, In[0], float3( 1,0,0),float2(In[0].TexCd.x,0), GSOut);
	GS_Point2D( m1, In[1], float3(-1,0,0),float2(In[1].TexCd.x,1), GSOut);
	GS_Point2D( m1, In[1], float3( 1,0,0),float2(In[1].TexCd.x,0), GSOut);

    GSOut.RestartStrip();
}
[maxvertexcount(4)]
void gsTAPE2D(line GS_IN In[2], inout TriangleStream<PS_IN>GSOut){
	if(In[1].TexCd.y==1)return;
	//float3 n0=normalize(mul(float4(In[0].Pos.xyz,1),tW).xyz-tVI[3].xyz);
	//float3 n1=normalize(mul(float4(In[1].Pos.xyz,1),tW).xyz-tVI[3].xyz);
	float3 n0=mul(float3(0,0,1),(float3x3)tVI);
	float3 n1=mul(float3(0,0,1),(float3x3)tVI);

	float3x3 m0=lookat(In[0].Dir,n0);
	float3x3 m1=lookat(In[1].Dir,n1);
	
    float3 pos0 = In[0].Pos;
    float3 pos1 = In[1].Pos;

	GS_Point2D( m0, In[0], float3(-1,0,0),float2(In[0].TexCd.x,1), GSOut);
	GS_Point2D( m0, In[0], float3( 1,0,0),float2(In[0].TexCd.x,0), GSOut);
	GS_Point2D( m1, In[1], float3(-1,0,0),float2(In[1].TexCd.x,1), GSOut);
	GS_Point2D( m1, In[1], float3( 1,0,0),float2(In[1].TexCd.x,0), GSOut);

    GSOut.RestartStrip();
}
[maxvertexcount(4)]
void gsTAPE3D(line GS_IN In[2], inout TriangleStream<PS_IN>GSOut){
	if(In[1].TexCd.y==1)return;
	float3 n0=normalize(mul(float4(In[0].Pos.xyz,1),tW).xyz-tVI[3].xyz);
	float3 n1=normalize(mul(float4(In[1].Pos.xyz,1),tW).xyz-tVI[3].xyz);
	//float3 n0=mul(float3(0,0,1),(float3x3)tVI);
	//float3 n1=mul(float3(0,0,1),(float3x3)tVI);

	float3x3 m0=lookat(In[0].Dir,-UpVector);
	float3x3 m1=lookat(In[1].Dir,-UpVector);
	
    float3 pos0 = In[0].Pos;
    float3 pos1 = In[1].Pos;

	GS_Point2D( m0, In[0], float3(-1,0,0),float2(In[0].TexCd.x,1), GSOut);
	GS_Point2D( m0, In[0], float3( 1,0,0),float2(In[0].TexCd.x,0), GSOut);
	GS_Point2D( m1, In[1], float3(-1,0,0),float2(In[1].TexCd.x,1), GSOut);
	GS_Point2D( m1, In[1], float3( 1,0,0),float2(In[1].TexCd.x,0), GSOut);

    GSOut.RestartStrip();
}

bool ReflectionUV=0;
float4 PS(PS_IN In) : SV_Target{
	float3 nv=mul(In.Norm,(float3x3)tV);
	float2 uv=In.TexCd.xy;
	if(ReflectionUV)uv=nv.xy*.5*float2(1,-1)+.5;
	uv=mul(float4((uv*2-1)*float2(1,-1),0,1),sbTexTransform[In.si%TexTransformCount]).xy*float2(1,-1)*.5+.5;
	
	float4 c=tex0.Sample(s0,uv,0);
	c=c*sbColor[In.si%ColorCount];
	c=c*Color;
	return c;
}

float4 PS_2D(PS_IN In) : SV_Target{
	float2 uv=In.TexCd.xy;
	uv=mul(float4((uv*2-1)*float2(1,-1),0,1),sbTexTransform[In.si%TexTransformCount]).xy*float2(1,-1)*.5+.5;
	
	float4 c=tex0.Sample(s0,uv,0);
	c=c*sbColor[In.si%ColorCount];
	c=c*Color;
	return c;
}
technique11 Tape
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( CompileShader( gs_5_0, gsTAPE() ) );
		SetPixelShader( CompileShader( ps_5_0, PS_2D() ) );
	}
}
technique11 Tape2D
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( CompileShader( gs_5_0, gsTAPE2D() ) );
		SetPixelShader( CompileShader( ps_5_0, PS_2D() ) );
	}
}
technique11 Tape3D
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( CompileShader( gs_5_0, gsTAPE3D() ) );
		SetPixelShader( CompileShader( ps_5_0, PS_2D() ) );
	}
}

technique11 Tube
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( CompileShader( gs_5_0, gsTUBE() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}

technique11 TubeSquare
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( CompileShader( gs_5_0, gsTUBESQ() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}