
//Rotate Function 
float4x4 Rotmatrix(float yaw,float pitch,float roll)
{
	float3 z=float3(yaw,pitch,roll)*acos(-1)*2;float3 x=cos(z),y=sin(z);
	return float4x4(x.y*x.z+y.x*y.y*y.z,-x.x*y.z,y.x*x.y*y.z-y.y*x.z,0,x.y*y.z-y.x*y.y*x.z,x.x*x.z,-y.y*y.z-y.x*x.y*x.z,0,x.x*y.y,y.x,x.x*x.y,0,0,0,0,1);
}
//Transform Function
float4 Transform3D(float4 PositionIn ,float3 Translate, float3 Scale, float3 Rotate, float3 TranslateOffset)
{
  
  matrix ScaleM = {Scale.x,0,0,0,  0,Scale.y,0,0,  0,0,Scale.z,0, TranslateOffset,1} ;
  PositionIn = mul(PositionIn,ScaleM);	
  
  PositionIn = mul(PositionIn,Rotmatrix(Rotate.x,Rotate.y,Rotate.z));
  
  PositionIn.xyz += Translate;
  
	
  return PositionIn ;
}

float4 Transform3DM(float4x4 MatrixIn , float4 PositionIn ,float3 Translate, float3 Scale, float3 Rotate, float3 TranslateOffset)
{

  matrix ScaleM = {Scale.x,0,0,0,  0,Scale.y,0,0,  0,0,Scale.z,0, TranslateOffset,1} ;
  
  PositionIn = mul(PositionIn,Rotmatrix(Rotate.x,Rotate.y,Rotate.z));
  PositionIn = mul(PositionIn,ScaleM);	
	
  PositionIn.xyz += Translate;
  PositionIn = mul(PositionIn,MatrixIn);
	
  return PositionIn ;
}
/* you can declare it like this 
	     float4 Trans =  Transform3D(input.PosO,Translate,Scale,PitchYawRoll,Toffset.xyz);
	     
         float4 TransM =  Transform3DM(mul(tW,tVP),input.PosO,Translate,Scale,PitchYawRoll,Toffset.xyz);

         Out.PosWVP  = mul(Trans,mul(tW,tVP));
	     Out.PosWVP  = TransM;
*/