StructuredBuffer<uint> SubsetVertexCount;
StructuredBuffer<float3> raysPos;
StructuredBuffer<float3> raysDir;
#if !defined(EPS)
#define EPS 0.000001f
#endif

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float GeomCount = 1;
	float TimeStamp = 0;
};

uint GetMergedGeomID(StructuredBuffer<uint> src, uint vid, uint geomcount)
{
	uint cvc = 0;
	uint res = 0;
	for(uint i=0; i<geomcount; i++)
	{
		cvc += src[i];
		if(vid < cvc)
		{
			res = i;
			break;
		}
	}
	return res;
}

struct VSin
{
	float4 cpoint : POSITION;
	uint vid : SV_VertexID;
};

struct GSin
{
	float4 pos : POSITION;
	uint gid : GEOMCUNT;
};

struct GSout
{
	float4 pos : SV_Position;
	float dist : RAYDICK;
	float gid : GEOMCUNT;
	float ts : DETHKLOK;
	uint rid : SHOWMEYOURIDBITCH;
};

GSin VS(VSin input)
{
    GSin output;
	output.pos = mul(input.cpoint, tW);
	output.gid = GetMergedGeomID(SubsetVertexCount, input.vid, GeomCount);
    return output;
}

[maxvertexcount(1)]
void GS(triangle GSin input[3], inout PointStream<GSout>GSOut)
{
	GSout o;
	uint numStructs;uint stride;
	raysPos.GetDimensions(numStructs, stride);
	for(int i=0;i<numStructs;i++){
	float3 raypos=raysPos[i];
	float3 raydir=raysDir[i];
	float3 diff = raypos - input[0].pos.xyz;
	float3 faceEdgeA = input[1].pos.xyz - input[0].pos.xyz;
    float3 faceEdgeB = input[2].pos.xyz - input[0].pos.xyz;
    
	float3 norm = cross(faceEdgeB, faceEdgeA);
	//norm = normalize(norm);
	
	//Ray/Triangle intersection, from 
	// www.geometrictools.com
	
	float DdN = dot(raydir,norm);
    float fsign;
	float3 intersectPoint;
	bool hit = true;
	
    if (DdN > EPS)
    {
        fsign = 1.0f;
    }
    else if (EPS)
    {
        fsign = -1.0;
        DdN = -DdN;
    }
    else
    {
        hit = false;
    }
	
	
	if (hit)
	{
		hit = false;
		float DdQxE2 = fsign*dot(raydir, cross(faceEdgeB,diff));
		if (DdQxE2 >= 0.0f)
	    {
	    	float DdE1xQ = fsign*dot(raydir,cross(diff,faceEdgeA)); 
	        if (DdE1xQ >= 0.0f)
	        {
	            if (DdQxE2 + DdE1xQ <= DdN)
	            {	
	            // Line intersects triangle, check if ray does.
	                float QdN = -fsign* dot(diff,norm);
	                if (QdN >= 0.0f)
	                {
	                    float inv = 1/DdN;
                    	float dickface = QdN*inv;
	                	intersectPoint = raypos + dickface * raydir;
	                	hit = true;
	                }
	            }
	        }
	    }
	}
	if(hit)
	{
		o.pos.xyz = intersectPoint;
		o.pos.w = 1;

		o.dist = distance(intersectPoint, raypos);
		o.gid = input[0].gid+1;
		o.ts = TimeStamp;
		o.rid=i;
		GSOut.Append(o);
	}
		
	}
}

GeometryShader StreamOutGS = ConstructGSWithSO( CompileShader( gs_5_0, GS() ),
	"SV_Position.xyz;RAYDICK.x;GEOMCUNT.x;DETHKLOK.x;SHOWMEYOURIDBITCH.x"
);

technique11 Layout
{
	pass P0
	{
		
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( StreamOutGS );

	}
}