

#include "Bicubic.fxh"

//blend properties
//!!!!!!!!!!!!!!!!!!!!!
// Change here to match your blend region count.
// This should generally be equal your viewport*renderer count
#define nRegions 4
//!!!!!!!!!!!!!!!!!!!!!


// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer 
float4x4 tWVP: WORLDVIEWPROJECTION;

//texture
Texture2D texture2d <string uiname="Texture";>;
float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };


bool PolarCoords = true;

float yBlend_Top=1;
float yBlend_Bot=-1;
float xBlend_Left=-1;
float xBlend_Right=1;
float blendWidth=0.1;

float blendWidthT=0.04;
float blendWidthB=0.04;
float blendWidthL=0.04;
float blendWidthR=0.04;

float3 gammaRGB=1;

int ViewIndex: VIEWPORTINDEX;
int ViewCount: VIEWPORTCOUNT;
int ViewIndexIN;


//texture projection properties
bool useProjection=false; // false=use vertex tex coords, true=use world coords
float4x4 tProjector;


SamplerState g_samLinear 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};


SamplerState g_samPoint : IMMUTABLE
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};


//texture transformation marked with semantic TEXTUREMATRIX to achieve symmetric transformations

float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;
//alpha
float Alpha <float uimin=0.0; float uimax=1.0;> = 1;

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : SV_POSITION;
    float4 TexCd : TEXCOORD0;
    float4 PosW : TEXCOORD1;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
    float4 PosO  : POSITION,
    float4 TexCd : TEXCOORD0
    )
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

	PosO.xyz*=(ViewIndexIN==ViewIndex);
	
    //transform position
    Out.Pos = mul(PosO, tWVP);
    float4 PosW = mul(PosO, tW);

    //transform texturecoordinates
    if (useProjection)
    {
        Out.TexCd = mul(PosW, tProjector);
    }
    else
        Out.TexCd = mul(TexCd, tTex);
    
    Out.PosW = mul(PosO, tW);
    
    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float3 factorY(float pos)
{
   float yTop = yBlend_Bot;
   float yBase = yBlend_Top;

   float factortop = smoothstep(yTop-blendWidthT/2,
                                 yTop+blendWidthT/2,
                                 pos);
   float factorbottom = 1-smoothstep(yBase-blendWidthB/2,
                                 yBase+blendWidthB/2,
                                 pos);
 return pow(factortop * factorbottom, gammaRGB);
}
// --------------------------------------------------------------------------------------------------
float3 factorX(float pos)
{
   float xTop = xBlend_Left;
   float xBase = xBlend_Right;

   float factortopX = smoothstep(xTop-blendWidthR/2,
                                 xTop+blendWidthR/2,
                                 pos);
   float factorbottomX = 1-smoothstep(xBase-blendWidthL/2,
                                 xBase+blendWidthL/2,
                                 pos);
    return pow(factortopX * factorbottomX, gammaRGB);
}

   float2 XYZtoUV(float3 p)
	{p=normalize( p );
 return float2(atan2(p.x,-p.z)/acos(-1)*.5+.5,asin(-p.y)/acos(-1)+.5);
}


float4 PSBlend(vs2ps In): SV_Target
{
  
	
	
	
	
	float4 col = texture2d.Sample(g_samLinear,In.TexCd.xy) * cAmb;
	
	float2 PolarPos =  XYZtoUV(In.PosW.xyz);
	
	if (PolarCoords)
    {
    	
    col.rgb *= factorX(PolarPos.x);
    col.rgb *= factorY(PolarPos.y);
    
    }
    else
	{
		
	col.rgb *= factorX(In.PosW.x);
    col.rgb *= factorY(In.PosW.y);
    
	}

	
	col.a *= Alpha;
	
    return col;
	
	

  return col;
}





technique10 Blend
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSBlend() ) );
	}
}

