//Electricty PS1.1 / VS2.0
//
// -----------------------------------------------------------------------------
// PARAMETERS:
// ------------------------------------------------------------------------------

//Tranforms
float4x4 tWVP: WORLDVIEWPROJECTION;

//Tweaks

float4 col2 : COLOR <String uiname="Color"; >  = {1, 1, 1, 1};
float glowStrength;
float ambientGlow;
float ambientGlowHeightScale;
float height;
float glowFallOff;
float speed;
float vertexNoise;
float time;

//Texture

texture Noise_Tex;
sampler Noise = sampler_state
{
   Texture = (Noise_Tex);
   ADDRESSU = WRAP;
   ADDRESSV = WRAP;
   ADDRESSW = WRAP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
};
//Structure

struct vs2ps {
   float4 Pos: POSITION;
   float2 texCoord: TEXCOORD;
};

// -----------------------------------------------------------------------------
// VERTEXSHADER
// -----------------------------------------------------------------------------

vs2ps VS(

   float4 Pos: POSITION)
{

   vs2ps Out = (vs2ps)0;

   // Clean up inaccuracies
   Pos.xy = sign(Pos.xy);

   Out.Pos = mul(Pos, tWVP);
   Out.texCoord = Pos.xy;

   return Out;
}

// -----------------------------------------------------------------------------
// PIXELSHADER
// -----------------------------------------------------------------------------

float4 PS(
float2 texCoord: TEXCOORD) : COLOR
{

float2 t = float2(speed * time * 0.5871 - vertexNoise * abs(texCoord.y), speed * time);

   // Sample at three positions for some horizontal blur
   // The shader should blur fine by itself in vertical direction
   float xs0 = texCoord.x;
   float xs1 = texCoord.x;
   float xs2 = texCoord.y + texCoord.x ;

   // Noise for the three samples
   float noise0 = tex3D(Noise, float3(xs0, t)).r;
   float noise1 = tex3D(Noise, float3(xs1, t)).r;
   float noise2 = tex3D(Noise, float3(xs2, t)).r;

   // The position of the flash
   float mid0 = height * (noise0 * 2 - 1) * (1 - xs0 * xs0);
   float mid1 = height * (noise1 * 2 - 1) * (1 - xs1 * xs1);
   float mid2 = height * (noise2 * 2 - 1) * (1 - xs2 * xs2);

   // Distance to flash
   float dist0 = abs(texCoord.y - mid0);
   float dist1 = abs(texCoord.y - mid1);
   float dist2 = abs(texCoord.y - mid2);

   // Glow according to distance to flash
   float glow = 1.0 - pow(0.25 * (dist0 + 2 * dist1 + dist2), glowFallOff);

   // Add some ambient glow to get some power in the air feeling
   float ambGlow = ambientGlow * (1 - xs1 * xs1) * (1 - abs(ambientGlowHeightScale * texCoord.y));

   return (glowStrength * glow * glow + ambGlow) * col2;
}


//--------------------------------------------------------------//
// Technique
//--------------------------------------------------------------//
technique Electricty
{
   pass P0
   {

      VertexShader = compile vs_1_1 VS();
      PixelShader = compile ps_2_0 PS();
   }

}
