//@author: dottore
//@description: 3D Checkerboard effect, created by procedural texturing.
//              Texture is pre-calculated, using the HLSL virtual machine (VM).
//              As an "extra," the check pattern is also applied to the specular
//              value, to make the variation between materials stronger.
//@tags: pattern, directional-light
//@credits: nVidia

/*********************************************************************NVMH3****
File:  $Id: //sw/devtools/ShaderLibrary/1.0/HLSL/checker3d.fx#1 $

Copyright NVIDIA Corporation 2002-2007
TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, THIS SOFTWARE IS PROVIDED
*AS IS* AND NVIDIA AND ITS SUPPLIERS DISCLAIM ALL WARRANTIES, EITHER EXPRESS
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL NVIDIA OR ITS SUPPLIERS
BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT, OR CONSEQUENTIAL DAMAGES
WHATSOEVER (INCLUDING, WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR ANY OTHER PECUNIARY LOSS)
ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF NVIDIA HAS
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

    The checker pattern is aligned to world coordinates in this sample.

    $Date: 2007/02/27 $

******************************************************************************/

/************* UN-TWEAKABLES **************/

float4x4 WvpXf : WorldViewProjection < string UIWidget="None"; >;
float4x4 WorldXf : World < string UIWidget="None"; >;
float4x4 ViewI : ViewInverse < string UIWidget="None"; >;
float4x4 WorldIT : WorldInverseTranspose < string UIWidget="None"; >;

/******** TWEAKABLES ****************************************/

half3 LampDir : Direction <
    string Object = "DirectionalLight";
    string UIName =  "Lamp Direction";
    string Space = "World";
> = {0.7f, -0.7f, -0.7f};

float4 AmbiColor : COLOR <
    string UIName =  "Ambient Light";
    string UIWidget = "Color";
> = {0.07f, 0.07f, 0.07f, 0.07f};


float4 BrightColor : COLOR <
    string UIName = "Light Checker Color";
> = {1.0f, 0.8f, 0.3f, 1.0f};

float4 DarkColor : COLOR <
    string UIName = "Dark Checker Color";
> = {0.0f, 0.2f, 0.4f, 1.0f};

float SpecExpon : SpecularPower <
    string UIWidget = "slider";
    float UIMin = 1.0;
    float UIMax = 128.0;
    float UIStep = 1.0;
    string UIName =  "Specular Power";
> = 20.0;

float Ks <
    string UIWidget = "slider";
    float UIMin = 0.0;
    float UIMax = 1.0;
    float UIStep = 0.05;
    string UIName =  "Specular";
> = 0.8;


float Balance <
    string UIWidget = "slider";
    float uimin = 0.0;
    float uimax = 1.0;
    float uistep = 0.01;
    string UIName = "Light::Dark Ratio";
> = 0.31;

float Scale : UNITSSCALE <
    string units = "inches";
    string UIWidget = "slider";
    float uimin = 0.01;
    float uimax = 5.0;
    float uistep = 0.01;
    string UIName = "Checker Size";
> = 3.4;

/////////////// prodecural texture /////////////

#define TEX_SIZE 64

texture stripeTex <
    string function = "MakeStripe";
    string UIWidget = "None";
    float2 Dimensions = { TEX_SIZE, TEX_SIZE };
>;

sampler2D stripeSampler = sampler_state
{
    Texture = <stripeTex>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    AddressU = WRAP;
    AddressV = CLAMP;
};

/*********** texture shader ******/

float4 MakeStripe(float2 Pos : POSITION,float ps : PSIZE) : COLOR
{
   float v = 0;
   float nx = Pos.x+ps; // keep the last column full-on, always
   v = nx > Pos.y;
   return float4(v.xxxx);
}

/************* DATA STRUCTS **************/

/* data from application vertex buffer */
struct appdata {
    float3 Position    : POSITION;
    float4 UV        : TEXCOORD0;
    float4 Normal    : NORMAL;
};

/* data passed from vertex shader to pixel shader */
struct vertexOutput {
    float4 HPosition    : POSITION;
    float4 TexCoord    : TEXCOORD0;
	float3 WorldNormal : TEXCOORD1;
	float3 WorldView : TEXCOORD2;
};

/*********** vertex shader ******/

vertexOutput mainVS(appdata IN) {
    vertexOutput OUT;
    float4 Po = float4(IN.Position.x,IN.Position.y,IN.Position.z,1.0);    // object space
    float4 hpos  = mul(Po, WvpXf);        // position (projected)
    OUT.HPosition  = hpos;
    float4 Pw = mul(Po, WorldXf); // world coords
    OUT.TexCoord = Pw * Scale;
    float4 Nn = normalize(IN.Normal);
    OUT.WorldView = normalize(ViewI[3].xyz - Pw);
    OUT.WorldNormal = mul(Nn, WorldIT).xyz;
    return OUT;
}

/******************** pixel shader *********************/

float4 strokeTexPS(vertexOutput IN) : COLOR {
    float stripex = tex2D(stripeSampler,float2(IN.TexCoord.x,Balance)).x;
    float stripey = tex2D(stripeSampler,float2(IN.TexCoord.y,Balance)).x;
    float stripez = tex2D(stripeSampler,float2(IN.TexCoord.z,Balance)).x;
    float check = abs(abs(stripex - stripey) - stripez);
    float3 dColor = lerp(BrightColor,DarkColor,check).xyz;
    float3 Nn = normalize(IN.WorldNormal);
    float3 Vn = normalize(IN.WorldView);
    float3 Hn = normalize(Vn - LampDir);
    float4 litV = lit(dot(-LampDir,Nn),dot(Hn,Nn),SpecExpon);
    float spec = litV.z*check*Ks;
	float3 result = (dColor * (AmbiColor + litV.yyy)) + spec.xxx;
    return float4(result.xyz,1.0);
}

/*************/

technique checker3d <
	string Script = "Pass=p0;";
> {
    pass p0  <
		string Script = "Draw=geometry;";
    > {        
        VertexShader = compile vs_2_0 mainVS();
        ZEnable = true;
        ZWriteEnable = true;
        CullMode = None;
        PixelShader = compile ps_2_0 strokeTexPS();
    }
}

/***************************** eof ***/
