Texture2D InputTexture;

int kernelSize = 3;

RWTexture2D<float4> RWOutputTexture : BACKBUFFER;

[numthreads(64,1,1)]
void CS_Simple(uint3 tid : SV_DispatchThreadID)
{
	int w,h,d;	
	InputTexture.GetDimensions(0,w,h,d);
	
	float4 sum = 0.0f;
	int cnt = 0;
	for (int i = max(0, (int)tid.x - kernelSize); i < min(w, (int)tid.x+ kernelSize); i++)
	{
		sum += InputTexture.Load(int3(i,tid.y,0));
		cnt++;
	}
	
	RWOutputTexture[tid.xy] = sum / (float)cnt;
}



technique11 Simple
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_Simple() ) );
	}
}




