StructuredBuffer<float> FloatBuffer;

RWStructuredBuffer<uint2> RWBoundsBuffer : BACKBUFFER;

[numthreads(64,1,1)]
void CS_Simple(uint3 tid : SV_DispatchThreadID)
{
	uint f = asuint(FloatBuffer[tid.x]);
	uint dummy;
	InterlockedMin(RWBoundsBuffer[0].x, f, dummy);
	InterlockedMax(RWBoundsBuffer[0].y, f, dummy);
}


groupshared uint2 localBounds;

[numthreads(64,1,1)]
void CS_GroupShared(uint3 tid : SV_DispatchThreadID, uint3 gid : SV_GroupThreadID)
{
	if (gid.x == 0)
	{
		localBounds.x = asuint(10000000.0f);
		localBounds.y = asuint(0.0f);
	}
	GroupMemoryBarrierWithGroupSync();
	
	uint f = asuint(FloatBuffer[tid.x]);
	uint dummy;
	InterlockedMin(localBounds.x, f, dummy);
	InterlockedMax(localBounds.y, f, dummy);
	
	GroupMemoryBarrierWithGroupSync();
	
	if (gid.x == 0)
	{
		InterlockedMin(RWBoundsBuffer[0].x, localBounds.x, dummy);
		InterlockedMax(RWBoundsBuffer[0].y, localBounds.y, dummy);
	}
}

technique11 Simple
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_Simple() ) );
	}
}

technique11 GroupShared
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_GroupShared() ) );
	}
}




