Texture2D<uint> ObjectIDTexture;
Texture2D<float> CollisionTexture;

float minBright = 0.1f;

RWStructuredBuffer<uint> RWCountBuffer : BACKBUFFER;

[numthreads(8,8,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	uint w,h,d;
	ObjectIDTexture.GetDimensions(0,w, h, d);
	if (tid.x >= w || tid.y >= h)
		return;
	
	float b = CollisionTexture[tid.xy];
	uint id = ObjectIDTexture[tid.xy];
	
	if (b > 0.0f && id > 0)
	{
		uint dummy;
		InterlockedAdd(RWCountBuffer[id-1],1,dummy);
	}
}

technique10 Copy
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}




