StructuredBuffer<uint> HitCountBuffer;

AppendStructuredBuffer<uint> AppendIdBuffer : BACKBUFFER;

[numthreads(64,1,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	uint cnt, stride;
	HitCountBuffer.GetDimensions(cnt, stride);
	if (tid.x >= cnt)
		return;
	
	uint hitCount = HitCountBuffer[tid.x];
	if (hitCount > 0)
	{
		AppendIdBuffer.Append(tid.x);
	}
}

technique10 Copy
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}




