struct PosColor
{
	float3 pos;
	float4 color;
};


StructuredBuffer<float3> PositionBuffer;
StructuredBuffer<float4> ColorBuffer;

float minY;
AppendStructuredBuffer<PosColor> AppendPCBuffer : BACKBUFFER;

[numthreads(64,1,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	float3 p = PositionBuffer[tid.x];
	
	if (p.y > minY)
	{
		PosColor pc;
		pc.pos = p;
		pc.color = ColorBuffer[tid.x];
		AppendPCBuffer.Append(pc);
	}
}

technique10 Copy
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}




