StructuredBuffer<float3> PositionBuffer;

float minY;
AppendStructuredBuffer<uint> AppendPCBuffer : BACKBUFFER;

[numthreads(64,1,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	float3 p = PositionBuffer[tid.x];
	
	if (p.y > minY)
	{
		AppendPCBuffer.Append(tid.x);
	}
}

technique10 Copy
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}




