#include "RawUtils.fxh"
#include "RawIndexedGeometry.fxh"
  

[numthreads(1,1,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	
	float3 p0 = normalize(float3(1, 1, 1));
	float3 p1 = normalize(float3(-1, -1, 1));
	float3 p2 = normalize(float3(1, -1, -1));
	float3 p3 = normalize(float3(-1, 1, -1));
	
	uint i0,i1,i2,i3;
	/*i0 = AppendPosition(p0);
	i1 = AppendPosition(p1);
	i2 = AppendPosition(p2);
	i3 = AppendPosition(p3);*/
	
	//Use this on nvidia, on ati can use the following 4 lines above
	i0 = AppendPositionSafe(p0);
	i1 = AppendPositionSafe(p1);
	i2 = AppendPositionSafe(p2);
	i3 = AppendPositionSafe(p3);
	
	AppendTriangle(uint3(i0,i1,i2));
	AppendTriangle(uint3(i1,i2,i3));
	AppendTriangle(uint3(i2,i3,i0));
	AppendTriangle(uint3(i3,i0,i1));
} 

technique10 Copy 
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}  