#include "RawUtils.fxh"
#include "RawPosColor.fxh"
 
StructuredBuffer<float2> random2dPoints;

[numthreads(64,1,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	uint id = tid.x;

	WritePosition(id, float4(random2dPoints[id],0.0f,1.0f));
	WriteColor(id,1);
	
	if (tid.x == 0)
	{
		SetDrawCount(256);
	}
}

technique10 Copy
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}