RWStructuredBuffer<uint> RWCountBuffer : BACKBUFFER;

int minHit = 1;

[numthreads(64,1,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	uint cnt, stride;
	RWCountBuffer.GetDimensions(cnt, stride);
	if (tid.x >= cnt)
		return;
	
	RWCountBuffer[tid.x] = RWCountBuffer[tid.x] > (uint)minHit ? 1 : 0;
}

technique10 Copy
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}




