#ifndef RAW_POSCOLOR_FXH
#define RAW_POSCOLOR_FXH

#include "RawUtils.fxh"

int ElementCount = 256;

#define HEADER_SIZE 16
#define START_POSITION HEADER_SIZE
#define START_COLOR (HEADER_SIZE + 16 * ElementCount)

float4 ReadPosition(uint index)
{
	return ReadFloat4(START_POSITION + index * 16);
} 

void WritePosition(uint index, float4 position)
{
	WriteFloat4(START_POSITION + index * 16, position);
}

float4 ReadColor(uint index)
{
	return ReadFloat4(START_COLOR + index * 16);
}

void WriteColor(uint index, float4 color)
{
	WriteFloat4(START_COLOR + index * 16, color);
}

void SetDrawCount(uint drawCount)
{
	SetIndirectDraw(0, drawCount, 1);
}

void SetDispatchCall(uint groupSize)
{
	SetIndirectDispatch(0, uint3((ElementCount+groupSize-1)/groupSize,1,1));
}



#endif