#ifndef RAWUTILS_FXH
#define RAWUTILS_FXH


globallycoherent RWByteAddressBuffer RWByteBuffer : BACKBUFFER;

float ReadFloat(uint location)
{
	return asfloat(RWByteBuffer.Load(location));
}

float2 ReadFloat2(uint location)
{
	uint2 data = RWByteBuffer.Load2(location);
	return float2(asfloat(data.x),asfloat(data.y));
}

float3 ReadFloat3(uint location)
{
	uint3 data = RWByteBuffer.Load3(location);
	return float3(asfloat(data.x),asfloat(data.y), asfloat(data.z));
}

float4 ReadFloat4(uint location)
{
	uint4 data = RWByteBuffer.Load4(location);
	return float4(asfloat(data.x),asfloat(data.y), asfloat(data.z), asfloat(data.w));
}

void WriteFloat(uint location, float f)
{
	RWByteBuffer.Store(location, asuint(f));
}

void WriteFloat2(uint location, float2 f)
{
	RWByteBuffer.Store2(location, uint2(asuint(f.x),asuint(f.y)));
}

void WriteFloat3(uint location, float3 f)
{
	RWByteBuffer.Store3(location, uint3(asuint(f.x),asuint(f.y),asuint(f.z)));
}

void WriteFloat4(uint location, float4 f)
{
	RWByteBuffer.Store4(location, uint4(asuint(f.x),asuint(f.y),asuint(f.z),asuint(f.w)));
}


void SetIndirectDraw(uint location, uint vertexCount, uint instanceCount)
{
	RWByteBuffer.Store4(location,uint4(vertexCount, instanceCount,0,0));
}

void SetIndirectDispatch(uint location, uint3 args)
{
	RWByteBuffer.Store3(location,args);
}

uint InterLockedAddSafe(uint addr, uint value)
{
	 uint comp,orig = RWByteBuffer.Load(addr);
	 [allow_uav_condition] do
	 {
	 	RWByteBuffer.InterlockedCompareExchange(addr, comp = orig, (orig + value), orig);
	 }
	 while(orig != comp);
	 
	return orig;
}

uint IncrementCounter(uint location)
{
	uint oldLocation;
	RWByteBuffer.InterlockedAdd(location, 1, oldLocation);
	return oldLocation;
}

#endif