struct PosColor
{
	float3 pos;
	float4 color;
};

StructuredBuffer<PosColor> PosColorBuffer;

cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	float4x4 tW : WORLD;
};

void VS(float4 posObj : POSITION, uint ii : SV_InstanceID,
	out float4 posScreen : SV_Position, out float4 color: COLOR)
{
	PosColor pc = PosColorBuffer[ii];
	
	posObj.xyz += pc.pos;

    posScreen  = mul(posObj,mul(tW,tVP));
	color = pc.color;
}


float4 PS_Tex(float4 posScreen : SV_Position, float4 color: COLOR): SV_Target
{
    return color;
}


technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Tex() ) );
	}
}




