StructuredBuffer<float3> PositionBuffer;
StructuredBuffer<float4> ColorBuffer;
StructuredBuffer<uint> IndicesBuffer;

cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	float4x4 tW : WORLD;
};

void VS(float4 posObj : POSITION, uint ii : SV_InstanceID,
	out float4 posScreen : SV_Position, out float4 color: COLOR)
{
	uint idx = IndicesBuffer[ii];
	
	posObj.xyz += PositionBuffer[idx];

    posScreen  = mul(posObj,mul(tW,tVP));
	color = ColorBuffer[idx];
}


float4 PS_Tex(float4 posScreen : SV_Position, float4 color: COLOR): SV_Target
{
    return color;
}


technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Tex() ) );
	}
}




