cbuffer cbPerDraw : register( b0 )
{
	float4x4 tV : VIEW;
	float4x4 tVP : VIEWPROJECTION;
};


cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};


void VS(float3 pos : POSITION, out float4 screenPos : SV_Position, out float3 viewPos : POSITIONVIEW)
{
    screenPos  = mul(float4(pos, 1.0f),mul(tW,tVP));
	viewPos = mul(float4(pos, 1.0f),mul(tW,tV)).xyz;
}


float4 PS(float4 pos : SV_Position, float3 viewPos : POSITIONVIEW): SV_Target
{
	float3 dx = ddx(viewPos);
	float3 dy = ddy(viewPos);
	float3 n = cross(dx,dy);
	
	return float4(normalize(n)*0.5f+0.5f, 1.0f);
	
}

technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




