cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
};


cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	int di : DRAWINDEX;
};

void VS(float4 pos : POSITION, out float4 screenPos : SV_Position)
{
	screenPos = mul(pos, mul(tW,tVP));
}

uint PS(float4 pos : SV_Position): SV_Target
{
    return di + 1;
}

technique11 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




