cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	float4x4 tVI : VIEWINVERSE;
};


cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float spriteRadius = 0.01f;
};

Texture2D spriteTexture; 

SamplerState linearSampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

float3 g_positions[4]: IMMUTABLE =
{
	float3( -1, 1, 0 ),
	float3( 1, 1, 0 ),
	float3( -1, -1, 0 ),
	float3( 1, -1, 0 ),
} ;

float2 g_texcoords[4]: IMMUTABLE = 
{ 
	float2(0,1), 
	float2(1,1),
	float2(0,0),
	float2(1,0),
};

struct vsInput 
{
	float4 pos : POSITION;
	float4 color : COLOR;
};


struct psInput 
{
	float4 pos : SV_Position;
	float4 color : COLOR;
	float2 uv : TEXCOORD0;
};


vsInput VS(vsInput input)
{
    return input;
}

[maxvertexcount(4)]
void GS(point vsInput input[1], inout TriangleStream<psInput> SpriteStream)
{
    psInput output;
	
	output.color = input[0].color;
	
    for(int i=0; i<4; i++)
    {
        float3 position = g_positions[i]*spriteRadius;
        position = mul( position, (float3x3)tVI ) + input[0].pos.xyz;
        output.pos = mul( float4(position,1.0), tVP );	
        output.uv = g_texcoords[i];
        SpriteStream.Append(output);
    }
    SpriteStream.RestartStrip();
}



float4 PS(float4 pos : SV_Position, float4 c : COLOR, float2 uv : TEXCOORD0): SV_Target
{
    float4 col = spriteTexture.Sample( linearSampler, uv) * c;
    return col;
}

technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetGeometryShader( CompileShader( gs_4_0, GS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




