#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "CrossAdvanced", Category = "2D", Help = "Basic template with 2 dimensional spread with bin size input", Tags = "")]
	#endregion PluginInfo
	public class C2DCrossAdvancedNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("X", DefaultValue = 1.0)]
		ISpread<ISpread<double>> FInputX;

		[Input("Y", DefaultValue = 1.0)]
		ISpread<ISpread<double>> FInputY;

		[Input("IncludeUpper", DefaultValue = 1.0)]
		ISpread<bool> FUpper;
		[Input("IncludeLower", DefaultValue = 1.0)]
		ISpread<bool> FLower;
		[Input("IncludeEqual", DefaultValue = 1.0)]
		ISpread<bool> FEqual;

		
		[Output("X")]
		ISpread<ISpread<double>> FOutputX;

		[Output("Y")]
		ISpread<ISpread<double>> FOutputY;

		[Import()]
		ILogger Flogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			SpreadMax = Math.Max(FInputX.SliceCount, FInputY.SliceCount);
			FOutputX.SliceCount = FOutputY.SliceCount = SpreadMax;
			for (int i=0;i<SpreadMax;i++) {
				int xCount = FInputX[i].SliceCount;
				int yCount = FInputY[i].SliceCount;
				
				FOutputY[i].SliceCount = FOutputX[i].SliceCount = 0;
				for (int j = 0;j<yCount;j++) 
					for (int k = 0;k<xCount;k++)
					{
						if (!FEqual[i] && (j == k)) {}
						else if (!FLower[i] && (j > k)) {}
						else if (!FUpper[i] && (j < k)) {}
						else {
							FOutputX[i].Add(FInputX[i][k]);
							FOutputY[i].Add(FInputY[i][j]);
						}
					}
			}
			

		}
	}
}
