#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "CrossAdvanced", Category = "2D", Help = "Generates all combination pairs of the two spreadable inputs", Tags = "Spreads")]
	#endregion PluginInfo
	public class C2DCrossAdvancedNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("X", DefaultValue = 1.0)]
		ISpread<ISpread<double>> FInputX;

		[Input("Y", DefaultValue = 1.0)]
		ISpread<ISpread<double>> FInputY;

		[Input("IncludeUpper", DefaultValue = 1.0)]
		ISpread<bool> FUpper;
		[Input("IncludeLower", DefaultValue = 1.0)]
		ISpread<bool> FLower;
		[Input("IncludeEqual", DefaultValue = 1.0)]
		ISpread<bool> FEqual;

		
		[Output("X")]
		ISpread<double> FOutputX;

		[Output("Y")]
		ISpread<double> FOutputY;

		[Output("BinSize")]
		ISpread<int> FBinSize;

		[Import()]
		ILogger Flogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			SpreadMax = Math.Max(FInputX.SliceCount, FInputY.SliceCount);
			FOutputX.SliceCount = FOutputY.SliceCount = 0;
			FBinSize.SliceCount = SpreadMax;
			int binSize = 0;
			for (int i=0;i<SpreadMax;i++) {
				int xCount = FInputX[i].SliceCount;
				int yCount = FInputY[i].SliceCount;
				
				binSize = 0;
				for (int y = 0;y<yCount;y++) {
					for (int x = 0;x<xCount;x++)
					{
						if (!FEqual[i] && (y == x)) {}
						else if (!FLower[i] && (y > x)) {}
						else if (!FUpper[i] && (y < x)) {}
						else {
							FOutputX.Add(FInputX[i][x]);
							FOutputY.Add(FInputY[i][y]);
							binSize++;
						}
					}
				}
				FBinSize[i] = binSize;
			}
		}
	}
}
