// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//texture size XY
float2 size_source;

//filter texture
Texture2D TexFilter <string uiname="Filter Texture";>;
//filter sampler
SamplerState s_filter:IMMUTABLE <bool visible=false;string uiname="Sampler";> {Filter=MIN_MAG_MIP_LINEAR;AddressU=WRAP;AddressV=WRAP;};

//texture lookup
float4 tex2Dbicubic(Texture2D texture2d,sampler s, float2 tex)
{

//pixel size XY
 float2 size_source = 1;
	uint dummy;
	texture2d.GetDimensions(0,size_source.x,size_source.y,dummy);
	
  float2 pix = 1.0/size_source;

  //calc filter texture coordinates
  float2 w = tex*size_source-float2(0.5, 0.5);

  // fetch offsets and weights from filter function
	float3 hg_x = TexFilter.SampleLevel(s_filter, w.xx, 0).xyz;
	float3 hg_y = TexFilter.SampleLevel(s_filter, w.yy, 0).xyz;

  float2 e_x = {pix.x, 0};
  float2 e_y = {0, pix.y};

  // determine linear sampling coordinates
  float2 coord_source10 = tex + hg_x.x * e_x;
  float2 coord_source00 = tex - hg_x.y * e_x;
  float2 coord_source11 = coord_source10 + hg_y.x * e_y;
  float2 coord_source01 = coord_source00 + hg_y.x * e_y;
  coord_source10 = coord_source10 - hg_y.y * e_y;
  coord_source00 = coord_source00 - hg_y.y * e_y;

  // fetch four linearly interpolated inputs

	float4 tex_source00 = texture2d.Sample( s, coord_source00);
	float4 tex_source10 = texture2d.Sample( s, coord_source10);
	float4 tex_source01 = texture2d.Sample( s, coord_source01);
	float4 tex_source11 = texture2d.Sample( s, coord_source11);
	
  // weight along y direction
  tex_source00 = lerp( tex_source00, tex_source01, hg_y.z );
  tex_source10 = lerp( tex_source10, tex_source11, hg_y.z );

  // weight along x direction
  tex_source00 = lerp( tex_source00, tex_source10, hg_x.z);

  return tex_source00;
}

// -------------------------------------------------------------------------

