//@author: tonfilm ported by circuitb
//@help: an infinite zoom into an image.
//@tags: escher
//@credits: Dag Ågren

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

Texture2D Tex <string uiname="Input";>;
//float2 R:TARGETSIZE;

SamplerState Samp <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};


	float4x4 tW: WORLD;        //the models world matrix
	//float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
	//float4x4 tP: PROJECTION;
	//float4x4 tWVP: WORLDVIEWPROJECTION;	
	float4x4 tVP : VIEWPROJECTION;
	float4x4 tTex <string uiname="Texture Transform"; bool uvspace=true; >;

#include "bicubicDX11.fxh"
#define pi 3.1415926535

cbuffer controls:register(b1){

	float2 center;
	float2 t;
	int2 p=1;
	float logbase = 0.2;
	//bool Mirror;
};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;

};
struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float2 TexCd: TEXCOORD0;
};


// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP  = mul(input.PosO,mul(tW,tVP));
    output.TexCd = mul(input.TexCd, tTex).xy;
    return output;
}
// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(vs2ps In): SV_Target
{

	float lo = 1/logbase;
	float2 tc = In.TexCd - center;

	float u_corner=2.0*pi*(p.y);
	float v_corner=lo*p.x;
	float diag=sqrt(u_corner*u_corner+v_corner*v_corner);
	
	float sin_a=v_corner/diag;
	float cos_a=u_corner/diag;
	float scale=diag/2.0/pi;

	float a=atan2(-tc.y,tc.x);
	float r=sqrt(tc.x*tc.x+tc.y*tc.y);

	float fu=a;
	float fv=log(r);

	float tmp=(fu*cos_a+fv*sin_a)*scale;
	fv=(-fu*sin_a+fv*cos_a)*scale;
	fu=tmp;

	fu/=2.0*pi;
	fv/=lo;
	
	float4 col = tex2Dbicubic(Tex,Samp,float2(fu,fv) - t);
    //float4 col = Mirror ?  Tex.Sample(Samp2,float2(fu,fv) - t) : Tex.Sample(Samp,float2(fu,fv) - t);
    return col;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique10 TDroste
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}
