//@author: vux
//@help: uses a different color depending if we have a bool hit flag to not
//@tags: color
//@credits: 

struct vsInput
{
    float4 posObject : POSITION;
	uint ii : SV_InstanceID;
};

struct psInput
{
    float4 posScreen : SV_Position;
	float4 color : COLOR0;
};

cbuffer cbPerDraw : register(b0)
{
	float4x4 tVP : LAYERVIEWPROJECTION;
	float4 colorNoHit <bool color = true;>;
	float4 colorHit <bool color = true;>;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

StructuredBuffer<float4x4> sbWorld;
StructuredBuffer<bool> sbHit;

psInput VS(vsInput input)
{
	psInput output;
	output.posScreen = mul(input.posObject,mul(mul(tW, sbWorld[input.ii]),tVP));
	output.color = sbHit[input.ii] ? colorHit : colorNoHit;
	return output;
}

float4 PS(psInput input): SV_Target
{
    return input.color;
}

technique11 Render
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}





