struct vsInputTextured
{
    float4 posObject : POSITION;
	float4 uv: TEXCOORD0;
	uint ii : SV_InstanceID;
};

struct psInputTextured
{
    float4 posScreen : SV_Position;
    float3 uv: TEXCOORD0;
};

struct DigitDisplay
{
	int sliceIndex;
	float2 location;
};

StructuredBuffer<DigitDisplay> DisplayBuffer;


Texture2DArray inputTexture <string uiname="Texture";>;

SamplerState linearSampler <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

cbuffer cbPerDraw : register(b0)
{
	float4x4 tVP : LAYERVIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

psInputTextured VS_Textured(vsInputTextured input)
{
	psInputTextured output;
	
	DigitDisplay dd = DisplayBuffer[input.ii];
	
	float4 pos = input.posObject;
	pos.xy += dd.location;
	
	output.posScreen = mul(pos,mul(tW,tVP));
	output.uv = float3(input.uv.xy, dd.sliceIndex);
	return output;
}

float4 PS_Textured(psInputTextured input): SV_Target
{
    float4 col = inputTexture.Sample(linearSampler,input.uv.xyz);
    return col;
}

technique11 Render
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS_Textured() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Textured() ) );
	}
}




