//@author: vux
//@help: template for simple compute shader (buffer write)
//@tags: template
//@credits: 

StructuredBuffer<float4x4> sbWorld;
RWStructuredBuffer<int> OutputBuffer : BACKBUFFER;

cbuffer cbSettings : register(b0)
{
	float2 mouse;
	uint elementCount;
}

[numthreads(64,1,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	if (tid.x >= elementCount)
		return;
	
	bool current = OutputBuffer[tid.x] == 1;
	float4x4 w = sbWorld[tid.x];
	
	float4 p = mul(float4(mouse, 0,1), w);
	bool hit = dot(p.xy, p.xy) < 0.25f;
	OutputBuffer[tid.x] = hit ? 1 : 0;
	
}

technique11 Apply
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}




