//@author: vux
//@help: scatter write to a texture
//@tags: template
//@credits: 

Texture2D<float4> InputTexture;

RWTexture2D<float4> OutputTexture : BACKBUFFER;

cbuffer cbSettings : register(b0)
{
	float4 bg <bool color=true;>;
	int writeX;
	int writeY;
}

[numthreads(8,8,1)]
void CS(uint3 tid : SV_DispatchThreadID)
{
	float4 color = InputTexture[tid.xy];
	
	OutputTexture[tid.xy+int2(writeX, writeY)] = bg+color;
}

technique11 Apply
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}




