//@author: vux
//@help: simple reverse spreads
//@tags: template
//@credits: 

StructuredBuffer<int> InputBuffer;


RWStructuredBuffer<int> OutputBuffer : BACKBUFFER;

cbuffer cbSettings : register(b0)
{
	uint elementCount;
}

[numthreads(64,1,1)]
void CS_Gather(uint3 tid : SV_DispatchThreadID)
{
	if (tid.x >= elementCount)
		return;
	
	int id = InputBuffer[elementCount-tid.x-1];
	OutputBuffer[tid.x] = id;
}

[numthreads(64,1,1)]
void CS_Scatter(uint3 tid : SV_DispatchThreadID)
{
	if (tid.x >= elementCount)
		return;
	
	int id = InputBuffer[tid.x];
	OutputBuffer[elementCount-tid.x-1] = id;
}

technique11 ApplyGather
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_Gather() ) );
	}
}


technique11 ApplyScatter
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_Scatter() ) );
	}
}




