//@author: KX
//@tags: Faceshift
//@credits: Dottore for a Data transform in the ParticlesGPU_3D
// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD ;
float4x4 tV: VIEW;         
float4x4 tP: PROJECTION ;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION ;

#include <effects\PhongDirectional.fxh>



texture TexTransform <string uiname="Transform Texture";>;

sampler SampTransform = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexTransform);          //apply a texture to the sampler
    MipFilter = none;                    //sampler states
    MinFilter = none;
    MagFilter = none;
};

texture NormTransform <string uiname="Norm Texture";>;

sampler Norm = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (NormTransform);          //apply a texture to the sampler
    MipFilter = none;                    //sampler states
    MinFilter = none;
    MagFilter = none;
};



//Color Texture
texture TextureMesh <string uiname="Texture Mesh";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TextureMesh);          //apply a texture to the sampler
    MipFilter = NONE ;                    //sampler states
    MinFilter = POINT;
    MagFilter = POINT;
};

float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;


// --------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------

struct vs2ps
{
    float4 Pos : POSITION ;
    float4 TexCd2 : TEXCOORD1 ;
    float3 LightDirV: TEXCOORD4 ;
    float3 NormV: TEXCOORD3 ;
    float3 ViewDirV: TEXCOORD5 ;
};


// VERTEXSHADERS


vs2ps VS(
    float4 PosO : POSITION ,
    float3 NormO: TEXCOORD2 ,
    float4 TexCd : TEXCOORD0 ,
    float4 TexCd2 : TEXCOORD1 )

{

    
    vs2ps Out = (vs2ps)0;
	
    //inverse light direction in view space
    Out.LightDirV = normalize(-mul(lDir, tV));
    

    //Transform Data from Transform texture
    
    float4 particleTransform = tex2Dlod(SampTransform, TexCd);
    
    PosO.xyz  = particleTransform.xyz;
    Out.Pos = mul(PosO, tWVP);
    
	float4 particleTransform2 = tex2Dlod(Norm, TexCd);
    

    NormO.xyz  += particleTransform2.xyz;
    Out.NormV = normalize(mul(NormO, tWV));


	Out.TexCd2 = mul(TexCd2, tTex);

    Out.ViewDirV = -normalize(mul(PosO, tWV));
    return Out;
}

// PIXELSHADERS:
float Alpha <float uimin=0.0; float uimax=1.0;> = 1;

float4 PS(vs2ps In): COLOR
{

    float4 col = tex2D(Samp, In.TexCd2);
	col.rgb *= PhongDirectional(In.NormV, In.ViewDirV, In.LightDirV);
	col.a = Alpha;
    return col;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------
technique Faceshift
{
    pass P0
    {
     VertexShader = compile vs_3_0 VS();
     PixelShader = compile ps_3_0 PS();
    }
}

