#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
using System.Text.RegularExpressions;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "FixSrt", Category = "String", Help = "Basic template with one string in/out", Tags = "")]
	#endregion PluginInfo
	public class StringFixSrtNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "")]
		ISpread<string> FInput;
		
		[Input("Number of Seconds to Add", DefaultValue=4)]
		ISpread<int> FSeconds;
		
		[Input("Enable")]
		ISpread<bool> FEnable;

		[Output("Output")]
		ISpread<string> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if (FEnable[0] == false) return;
			FOutput[0] = "";
			string[] a = FInput[0].Split('\n');
			FOutput.SliceCount = a.Length;
			for (var i=0; i<a.Length; i++) {
				
				Match match = Regex.Match(a[i], @"(.+\-\-\> )(\d\d)\:(\d\d):(\d\d)\,(\d\d)",
				    RegexOptions.IgnoreCase);
			
				if (match.Success)
				{
				    // Finally, we get the Group value and display it.
				    string g1 = match.Groups[1].Value;
				    string g2 = match.Groups[2].Value;
				    string g3 = match.Groups[3].Value;
				    string g4 = match.Groups[4].Value;
				    string g5 = match.Groups[5].Value;
				   // Console.WriteLine(key);
					int n4 = Convert.ToInt16(g4);
					int n3 = Convert.ToInt16(g3);
					int n2 = Convert.ToInt16(g2);
					n4 += FSeconds[0];
					if (n4>59) {
						n4 = n4-59;
						n3 += 1;
					}
					if (n3>59) {
						n3 = n3-59;
						n2 += 1;
					}
					
					string s4;
					string s3;
					string s2;
					if (n4<10) {
						s4 = "0" + n4.ToString();
					} else {
						s4 = n4.ToString();
					}
					
					if (n3<10) {
						s3 = "0" + n3.ToString();
					} else {
						s3 = n3.ToString();
					}
					
					if (n2<10) {
						s2 = "0" + n2.ToString();
					} else {
						s2 = n2.ToString();
					}
					
					
					FOutput[0] += g1 + s2 + ":" + s3 + ":" + s4 + "," + g5 + "\n";
				} else {
					FOutput[0] += a[i]+"\n";
				}

			}
		}
	}
}
