#include "RingBuffer.h"

RingBuffer::RingBuffer( unsigned int count, unsigned long bufSize )
	: _buffer(NULL), _count(count), _index(0), _size(bufSize)
{
	_buffer = new unsigned char[ _size * _count ];
	if (!_buffer) _size = 0;

	memset( _buffer, 0, _size * _count );
}

RingBuffer::~RingBuffer()
{
	delete[] _buffer;
}

void RingBuffer::insert( void *buf )
{
	memcpy(_buffer + _size*_index, buf, _size);
	if ( ++_index==_count ) _index = 0;
}

void *RingBuffer::getLast()
{
	return _buffer + (_size * _index);
}

void RingBuffer::flush()
{
    memset( _buffer, 0, _size * _count );     
}
