#ifndef _RINGBUFFER_H_
#define _RINGBUFFER_H_

#include <string.h>

class RingBuffer
{
private:
	unsigned char *_buffer;
	unsigned int _count;
	unsigned int _index;
	unsigned long _size;

public:
	// contructor, needs buffer count and size as input - creates empty ringbuffer
	RingBuffer( unsigned int count, unsigned long bufSize );
	// destructor
	~RingBuffer();
	// inserts the given buffer into the ringbuffer and increments the counter
	void insert( void *buf );
	// gets the last buffer
	void *getLast();
	
	void flush();
};

#endif
