#region usings
using System;
using System.Diagnostics;
using System.ComponentModel.Composition;
using System.Collections.Generic;
using System.Drawing;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "GPlayer", Category = "String", Help = "Plugin for gPlayer", Tags = "osc,gilbi")]
	#endregion PluginInfo
	public class StringGPlayerNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "")]
		ISpread<string> fInput;

		[Input("Bang to Read Input", DefaultValue = 0, IsSingle = true)]
		ISpread<bool> fReadBang;

		[Input("Reset", DefaultValue = 0, IsSingle = false)]
		ISpread<bool> fReset;

		[Input("Pause", DefaultValue = 1, IsSingle = true)]
		ISpread<bool> fPause;

		[Input("Speed", DefaultValue = 1, IsSingle = true)]
		ISpread<double> fSpeed;

		[Output("UDP Output")]
		ISpread<string> FUdpOutput;

		[Output("UDP Bang on Send")]
		ISpread<bool> FUdpBangOnSend;

		[Output("UDP Port")]
		ISpread<int> FUdpPort;
		
		[Output("TCP Output")]
		ISpread<string> FTcpOutput;

		[Output("TCP Bang on Send")]
		ISpread<bool> FTcpBangOnSend;

		[Output("TCP Port")]
		ISpread<int> FTcpPort;
		
		[Output("Elapsed Time (seconds)")]
		ISpread<double> FElapsedTime;
		
		[Output("Position (seconds)")]
		ISpread<double> FPosition;
		
		[Output("Header Description")]
		ISpread<string> FDescription;
		
		[Output("Header Port Types")]
		ISpread<string> FPortType; 

		[Output("Header Ports")]
		ISpread<int> FPorts;
		
		[Output("Header Port Names")]
		ISpread<string> FPortNames;

		[Output("Header Duration")]
		ISpread<double> FDuration;
		
		[Output("Input Line Count")]
		ISpread<int> FLineCount;

		[Output("Errors")]
		ISpread<string> FErrors;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		private List<string> data = new List<string>();
		private List<double> elapsedTime = new List<double>();
		private List<int> port = new List<int>();
		private List<char> portType = new List<char>();
		private List<bool> startNewPacket = new List<bool>();
		//private double time = 0;
		//private string records;
 
		private int index = 0; 

		private Stopwatch sw = new Stopwatch();

		private const string UDPTAG = "u";
		private const string TCPTAG = "t";
		private const string TIMETAG = "d";
		private const string PACKETTAG = "p";

		// RECORD SEPERATOR
		private const string RECSEP = "<[<grbk>]>\n";

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FUdpOutput.SliceCount = FUdpPort.SliceCount = FUdpBangOnSend.SliceCount = 
			FTcpOutput.SliceCount = FTcpPort.SliceCount = FTcpBangOnSend.SliceCount =0;
			//FUdpBangOnSend[0] = false;
			
			if (fReset[0]) {
				sw.Reset();
				index = 0;
			}

			if (fReadBang[0]) {
				FErrors[0] = "";
				data.Clear();
				elapsedTime.Clear();
				port.Clear();
				portType.Clear();
				startNewPacket.Clear();

				bool newpacket = false;
				double t = 0.0;
				string[] lines = fInput[0].Split(new string[] { RECSEP }, StringSplitOptions.None);

				FLineCount[0] = lines.Length;

				for (var i = 0; i < lines.Length; i++) {

					string line = lines[i];
					if ( i <= 2) {
						// header
						switch (i) {
							case 0: 
							FDescription[0] = line;
							break;
							
							case 1:
							string[] parts = line.Split(new string[] { "|" }, StringSplitOptions.None);
							FPorts.SliceCount = FPortNames.SliceCount = FPortType.SliceCount = parts.Length;
							for (var j = 0; j < parts.Length; j++) {
								string[] vals = parts[j].Split(new string[] { ":" }, StringSplitOptions.None);
								FPortType[j] = vals[0];
								FPorts[j] = int.Parse(vals[1]);
								FPortNames[j] = vals[2];								
							}
							break;
							
							case 2:
							FDuration[0] = double.Parse(line);
							break;
						}
					} else {
						// data
						string tag = line.Substring(0, 1);
						//FLogger.Log(LogType.Debug, "tag: "+tag);
						switch (tag) {
							case TIMETAG:
								t = double.Parse(line.Substring(1));
								newpacket = true;
								break;
							case PACKETTAG:
								newpacket = true;
								break;
							case TCPTAG:
							case UDPTAG:
								int startidx = line.IndexOf(")") + 1;
								int udp = int.Parse(line.Substring(2, startidx - 3));
								string d = line.Substring(startidx);
								//FLogger.Log(LogType.Debug, t.ToString()+" ("+udp.ToString()+") "+d );

								data.Add(d);
								elapsedTime.Add(t);
								port.Add(udp);
								portType.Add( tag.ToCharArray(0,1)[0] );
								startNewPacket.Add(newpacket);

								newpacket = false;
								break;
							default:
								FErrors[0] = "unexpected tag";
								break;

						}
					}
				}
			}
			// end if (fReadBang[0])
			FElapsedTime[0] = sw.Elapsed.Seconds + sw.Elapsed.Milliseconds * 0.001;
			double time = fSpeed[0] * FElapsedTime[0];
			FPosition[0] = time;
			
			
			if (fPause[0]) {
				if (sw.IsRunning)
					sw.Stop();
			} else {
				if (!sw.IsRunning && index < data.Count)
					sw.Start();

				if (index < data.Count) {
					if (elapsedTime[index] < time) {
						double t = elapsedTime[index];
						int udpcount = 0;
						int tcpcount = 0;
						do {
							switch (portType[index].ToString()) {
								case UDPTAG:
								FUdpOutput.SliceCount++;
								FUdpOutput[udpcount] = data[index];
								FUdpPort.SliceCount++;
								FUdpPort[udpcount] = port[index];
								FUdpBangOnSend.SliceCount++;
								FUdpBangOnSend[udpcount] = true;
								udpcount++;
								break;
								
								case TCPTAG:
								FTcpOutput.SliceCount++;
								FTcpOutput[tcpcount] = data[index];
								FTcpPort.SliceCount++;
								FTcpPort[tcpcount] = port[index];
								FTcpBangOnSend.SliceCount++;
								FTcpBangOnSend[tcpcount] = true;
								tcpcount++;
								break;
							}
							if (++index == data.Count) {
								sw.Stop();
								return;
							}
						} while (t == elapsedTime[index] && startNewPacket[index] == false);
					}
				}
			}
			// end if (fPause[0])
		}
	}
}
