#region usings
using System;
using System.Diagnostics;
using System.ComponentModel.Composition;
using System.Collections.Generic;
using System.Drawing;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "GRecroder", Category = "String", Help = "Plugin for gRecorder", Tags = "osc,gilbi")]
	#endregion PluginInfo
	public class StringGRecroderNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "")]
		ISpread<string> fInput;

		[Input("Bin Size", DefaultValue = 0)]
		ISpread<int> fBinSize;
		
		// These spreads should all be the same size as "Bin Size":
		[Input("Port", DefaultValue = 0)]
		ISpread<int> fPort;
		
		[Input("Port Type", DefaultString = "u")]
		ISpread<string> fPortType;

		[Input("Port Name", DefaultString = "")]
		ISpread<string> fPortName;

		[Input("Insert Bin Enabled", DefaultValue = 0)]
		ISpread<bool> fInsertEnabled;
		
		// Non-spreadable
		[Input("Init", DefaultValue = 0, IsSingle = true)]
		ISpread<bool> fInit;

		[Input("Pause", DefaultValue = 1, IsSingle = true)]
		ISpread<bool> fPause;


		[Input("Generate", DefaultValue = 0, IsSingle = true)]
		ISpread<bool> fGenerate;

		[Input("Add Time", DefaultValue = 0, IsSingle = true)]
		ISpread<double> fAddTime;

		[Output("Output")]
		ISpread<string> FOutput;

		[Output("Data Count")]
		ISpread<int> FDataCount;
		
		[Output("Time (seconds)")]
		ISpread<double> FTime;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		private List<string> data = new List<string>();
		private List<double> elapsedTime = new List<double>();
		private List<int> port = new List<int>();
		private List<char> portType = new List<char>();
		private List<bool> startNewPacket = new List<bool>();

		private Stopwatch sw = new Stopwatch();

		private double plusTime = 0;

		private const string UDPTAG = "u";
		private const string TCPTAG = "t";
		private const string TIMETAG = "d";
		private const string PACKETTAG = "p";
		
		// RECORD SEPERATOR
		private const string RECSEP = "<[<grbk>]>\n";
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if (fGenerate[0] && data.Count > 0) {
				FOutput[0] = "";
				double totalTime = elapsedTime[ elapsedTime.Count-1 ];
				
				// Line 1: Description
				FOutput[0] += "Recorded: " + DateTime.Now.ToString() + "\n";
				
				// Line 2: port info
				string ptype = (fPortType[0] == UDPTAG) ? "udp" : "tcp";
				FOutput[0] += RECSEP + ptype + ":" + fPort[0].ToString() + ":" + fPortName[0];
				for (int i = 1; i < fPort.SliceCount; i++) {
					ptype = (fPortType[i] == UDPTAG) ? "udp" : "tcp";
					FOutput[0] += "|" + ptype + ":" + fPort[i].ToString() + ":" + fPortName[i];
				}
				
				// Line 3: total time
				FOutput[0] += RECSEP + totalTime.ToString();

				// the rest: data
				double prevTime = -1;
				for (int i = 0; i < data.Count; i++) {
					if (elapsedTime[i] != prevTime) {
						FOutput[0] += RECSEP + TIMETAG + elapsedTime[i].ToString();
						prevTime = elapsedTime[i];
					} else if (startNewPacket[i]) {
						FOutput[0] += RECSEP + PACKETTAG;
					}
					FOutput[0] += RECSEP + portType[i].ToString() + "(" + port[i] + ")" + data[i];
				}
				//sw.Stop();
				// generate?
				return;
			}

			if (fInit[0]) { 
				sw.Reset();
				data.Clear();
				elapsedTime.Clear();
				port.Clear();
				portType.Clear();
				startNewPacket.Clear();
				
				FDataCount[0] = 0;
				plusTime = 0;
			}

			if (fAddTime[0] > 0) {
				plusTime += fAddTime[0];
			}

			if (fPause[0]) {
				if (sw.IsRunning)
					sw.Stop();
			} else {
				if (!sw.IsRunning)
					sw.Start();
			}

			double t = plusTime + sw.Elapsed.Seconds + sw.Elapsed.Milliseconds * 0.001;
			FTime[0] = t;
			
			if (fInput.SliceCount > 0) {
				int i = 0;
				for (int j = 0; j < fBinSize.SliceCount; j++) {
					for (int k = 0; k < fBinSize[j]; k++) {
						if (fInsertEnabled[j]) {
							startNewPacket.Add(i == 0);
							data.Add(fInput[i]);
							elapsedTime.Add(t);
							port.Add(fPort[j]);
							portType.Add( fPortType[j].ToCharArray(0,1)[0] );
						}
						i++;
					}
				}

				FDataCount[0] = data.Count;
			}
		}
	}
}
