#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
using VVVV.Graph;

using QuickGraph;
#endregion usings

using VertexType = System.String;
using EdgeType = System.String;

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "CreateGraph", Category = "Graph", Help = "Create a graph", Tags = "", Author = "tonfilm")]
	#endregion PluginInfo
	public class CreateGraphNode: GraphCreateGraphNode<VertexType, EdgeType>
	{
	}
	
	#region PluginInfo
	[PluginInfo(Name = "GetEdges", Category = "Graph", Help = "Enumerate the edges of a graph.", Tags = "", Author = "tonfilm")]
	#endregion PluginInfo
	public class GetEdgesNode: GraphGetEdges<VertexType, EdgeType>
	{
	}
	
	#region PluginInfo
	[PluginInfo(Name = "ShortestPath", Category = "Graph", Help = "Compute the shortest path between two vertices in the graph", Tags = "", Author = "tonfilm")]
	#endregion PluginInfo
	public class DijkstraPathNode: GraphShortestPath<VertexType, EdgeType>
	{
	}
}
