#region usings
using System;
using System.Drawing;
using System.IO;
using System.Text;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using ZXing;

using VVVV.Core.Logging;
#endregion usings





namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "ZXing", Category = "String", Version = "0.1", Help = "ZXing decode qrcodes", Tags = "")]
	#endregion PluginInfo
	public class C0_1StringZXingNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("raw BMP", DefaultString = "")]
		ISpread<Stream> FStreamIn;
		
		[Input("Try Hard", DefaultValue = 1.0, IsSingle = true)]
		ISpread<bool> FTryHard;

		[Input("Enabled", DefaultValue = 1.0, IsSingle = true)]
		ISpread<bool> FEnabled;
		
		[Output("String")]
		ISpread<string> FOutput;
		
		[Output("Float X")]
		ISpread<float> FPointsX;
		
		[Output("Float Y")]
		ISpread<float> FPointsY;
		
		[Output("Status")]
		ISpread<int> IStatus;
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;	
			FPointsX.SliceCount = SpreadMax;
			FPointsY.SliceCount = SpreadMax;
			IStatus.SliceCount = SpreadMax;
	
			for (int i = 0; i < SpreadMax; i++) {
				if (FEnabled[i]) {
					var bmp = Bitmap.FromStream( FStreamIn[i]);
					
					var reader = new ZXing.BarcodeReader {TryHarder = FTryHard[i]};
                	var result = reader.Decode((Bitmap)bmp);
					//var result = reader.DecodeMultiple((Bitmap)bmp);
					
					 ;
        			if (result != null)
         			{
            			FOutput[i] = ((ZXing.Result)(result)).Text;
         				FPointsX.SliceCount = result.ResultPoints.Length;
						FPointsY.SliceCount = result.ResultPoints.Length;
         				for (int j = 0; j < result.ResultPoints.Length; j++) {
         					FPointsX[j] = (2 * result.ResultPoints[j].X / bmp.Width) - 1 ;
         					FPointsY[j] = (-2 * result.ResultPoints[j].Y / bmp.Height) + 1;
         				}         					
         				IStatus[i] = 1;
         			}
         			else
         			{
            			FOutput[i] = "";
         				FPointsX.SliceCount = 0;
						FPointsY.SliceCount = 0;
         				IStatus[i] = 0;
         			}	
				}
			}

		}

	}
}
