#region usings
using System;
using System.IO;
using System.ComponentModel.Composition;
using System.Drawing;

using SlimDX;
using SlimDX.Direct3D9;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.PluginInterfaces.V2.EX9;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using VVVV.Utils.SlimDX;




using  System.Collections.Generic;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "ReaderVwf", Category = "Raw", Help = "Basic raw template which copies up to count bytes from the input to the output", Tags = "")]
	#endregion PluginInfo
	public class RawReaderVwfNode : IPluginEvaluate, IPartImportsSatisfiedNotification
	{
		#region fields & pins
		public class Info
		{
			public int Slice;
			public int Width;
			public int Height;
			public long Indice;
		}
		
		public abstract class Block {
			
			abstract public void GetData(Stream stream);
			abstract public override string ToString();
		}
		
		public class Vwf1 : Block {
			
			protected long Indice;
			protected string MagicNumber;
			protected int NumBlocks;
			protected int Offs;
			protected int Reserved;
			
			public Vwf1(long ind) {
				Indice = ind;
				MagicNumber = "vwf1";
			}
			
			public override void GetData(Stream stream) {
				stream.Position = Indice; 
				
				byte[] buffer = new byte[4];
				stream.Read(buffer, 0, 4);
				MagicNumber = System.Text.Encoding.UTF8.GetString(buffer);
				
				stream.Read(buffer, 0, 4);
				NumBlocks = (int)BitConverter.ToInt16(buffer, 0);
				
				stream.Read(buffer, 0, 4);
				Offs = (int)BitConverter.ToInt16(buffer, 0);
				
				stream.Read(buffer, 0, 4);
				Reserved = (int)BitConverter.ToInt16(buffer, 0);
			}
			
			public override string ToString() {
				string txt = "";
				txt += "---------\n";
				txt += "Indice: "+Indice.ToString()+" \n";
				txt += "MagicNumber: "+MagicNumber+" \n";
				txt += "NumBlocks: "+NumBlocks.ToString()+" \n";
				txt += "Offs: "+Offs.ToString()+" \n";
				txt += "Reserved: "+Reserved.ToString()+" \n";
				txt += "---------\n";
				return txt;
			}
		}
		
		public class Vwf2 : Block {
			
			protected long Indice;
			protected string MagicNumber;
			
			protected int SizeHeader;
			protected int Flags;
			protected int HMonitor;
			protected int Size;
			protected int Width;
			protected int Height;
			protected float[] White;
			protected float[] Black;
			protected float[] ReservedInfo;
			protected string Name;
			
			public Vwf2(long ind){
				Indice = ind;
				MagicNumber = "vwf2";
			}
			
			public override void GetData(Stream stream) {
				stream.Position = Indice; 
				
				byte[] buffer = new byte[4];
				stream.Read(buffer, 0, 4);
				MagicNumber = System.Text.Encoding.UTF8.GetString(buffer);
				
				stream.Read(buffer, 0, 4);
				SizeHeader = (int)BitConverter.ToInt32(buffer, 0);
				
				stream.Read(buffer, 0, 4);
				Flags = (int)BitConverter.ToInt32(buffer, 0);
				
				stream.Read(buffer, 0, 4);
				HMonitor = (int)BitConverter.ToInt32(buffer, 0);
				
				stream.Read(buffer, 0, 4);
				Size = (int)BitConverter.ToInt32(buffer, 0);
				
				stream.Read(buffer, 0, 4);
				Width = (int)BitConverter.ToInt32(buffer, 0);
				
				stream.Read(buffer, 0, 4);
				Height = (int)BitConverter.ToInt32(buffer, 0);
				
				White = new float[4];
				for(int i = 0; i < White.Length; i++){
					stream.Read(buffer, 0, 4);
					White[i] = (float)BitConverter.ToSingle(buffer, 0);
				}
				
				Black = new float[4];
				for(int i = 0; i < Black.Length; i++){
					stream.Read(buffer, 0, 4);
					Black[i] = (float)BitConverter.ToSingle(buffer, 0);
				}
				
				ReservedInfo = new float[16];
				for(int i = 0; i < ReservedInfo.Length; i++){
					stream.Read(buffer, 0, 4);
					ReservedInfo[i] = (float)BitConverter.ToSingle(buffer, 0);
				}
				
				buffer = new byte[256];
				stream.Read(buffer, 0, 256);
				Name = System.Text.Encoding.UTF8.GetString(buffer);
			}
			
			public override string ToString() {
				string txt = "";
				txt += "---------\n";
				txt += "Indice: "+Indice.ToString()+" \n";
				txt += "MagicNumber: "+MagicNumber+" \n";
				txt += "SizeHeader: "+SizeHeader.ToString()+" \n";
				txt += "Flags: "+Flags.ToString()+" \n";
				txt += "HMonitor: "+HMonitor.ToString()+" \n";
				txt += "Size: "+Size.ToString()+" \n";
				txt += "Width: "+Width.ToString()+" \n";
				txt += "Height: "+Height.ToString()+" \n";
				
				txt += "White: \n";
				if(White != null){
					for(int i = 0; i < White.Length; i++){
						txt += "    "+White[i].ToString()+" \n";
					}
				}
				txt += "Black: \n";
				if(Black != null){
					for(int i = 0; i < Black.Length; i++){
						txt += "    "+Black[i].ToString()+" \n";
					}
				}
				txt += "ReservedInfo: \n";
				if(ReservedInfo != null){
					string[] names = {"Row ind", "Column ind", "Row quantum", "Column quantum", "Original display width", "Original display height", "Type", "OffsetX", "OffsetY", "BlackLevel correction", "BlackLevel dark", "BlackLevel bright", "Identifier", "???", "???", "???", "???"};
					for(int i = 0; i < ReservedInfo.Length; i++){
						txt += "    "+names[i]+": "+ReservedInfo[i].ToString()+" \n";
					}
				}
				txt += "Name: "+Name+" \n";
				txt += "---------\n";
				return txt;
			}
		}
		
		[Input("Input", IsSingle=true)]
		public ISpread<Stream> FStreamIn;
		[Input("Block", IsSingle=true)]
		public ISpread<int> FBlock;
		[Input("Read", IsSingle=true, IsBang=true)]
		public IDiffSpread<bool> FRead;

		[Output("String Data")]
        public ISpread<String> FStringData;
		/*
		[Output("Warp Texture Out")]
        public ISpread<TextureResource<Info>> FWarpTextureOut;
		*/
		[Output("WarpData (Raw)")]
		public ISpread<Stream> FDataWarpOut;
		[Output("BlendData (Raw)")]
		public ISpread<Stream> FDataBlendOut;
		[Output("Success", IsSingle=true, IsBang=true)]
        public ISpread<bool> FSuccess;
		
		
		[Import()]
        public ILogger FLogger;
		#endregion fields & pins

		//called when all inputs and outputs defined above are assigned from the host
		public void OnImportsSatisfied()
		{
			//start with an empty stream output
			FStringData.SliceCount = 0;
			//FWarpTextureOut.SliceCount = 0;
			FSuccess.SliceCount = 0;
			FDataWarpOut.SliceCount = 0;
			FDataBlendOut.SliceCount = 0;
		}

		//called when data for any output pin is requested
		public void Evaluate(int spreadMax)
		{	
			FStringData.SliceCount = 1;
			string dataString = "";
			FSuccess.SliceCount = 1;
			FSuccess[0] = false;
			//si debug
			//FWarpTextureOut.ResizeAndDispose(1, CreateTextureResource);
			FDataWarpOut.ResizeAndDispose(1, () => new MemoryStream());
			FDataBlendOut.ResizeAndDispose(1, () => new MemoryStream());
			if (FRead.IsChanged && FRead[0]) 
			{
				//search headers 
				byte[] buffer = new byte[4];
				FStreamIn[0].Position = 0; 
				List<Block> blocks = new List<Block>();
				long cc = FStreamIn[0].Length/4-4;
				for(long i = 0; i < cc; i+=4) {
					FStreamIn[0].Read(buffer, 0, 4);
					string head = System.Text.Encoding.UTF8.GetString(buffer);
					if(head.Length >= 4 && string.Equals(head.Substring(0, 3), "vwf")){
						if(string.Equals(head, "vwf1")) blocks.Add(new Vwf1(i));
						if(string.Equals(head, "vwf2")) blocks.Add(new Vwf2(i));
					}
				}
				
				for(int i = 0; i < blocks.Count; i++){
					blocks[i].GetData(FStreamIn[0]);
					dataString += blocks[i].ToString();
				}
				
				FStreamIn[0].Position = 4; 
				FStreamIn[0].Read(buffer, 0, 4);
				int numBlock = (int)BitConverter.ToInt32(buffer, 0);
				int textureCount = numBlock/2;
				
				//FWarpTextureOut.ResizeAndDispose(1, CreateTextureResource);
				FDataWarpOut.ResizeAndDispose(1, () => new MemoryStream());
				FDataBlendOut.ResizeAndDispose(1, () => new MemoryStream());
				//create textures
				int ind  = 4500;
				
				for(int i = 0; i < textureCount; i++) {
					//var info = FWarpTextureOut[0].Metadata;
					FStreamIn[0].Position = 36; 
					FStreamIn[0].Read(buffer, 0, 4);
					int w = (int)BitConverter.ToInt32(buffer, 0);
					FStreamIn[0].Read(buffer, 0, 4);
					int h = (int)BitConverter.ToInt32(buffer, 0);
					if (i == FBlock[0]%textureCount)
					{
						int ss = w*h*16;
						FStreamIn[0].Position = ind;
						FDataWarpOut[0].Position = 0;
						FDataWarpOut[0].SetLength(ss);
						byte[] FBuffer = new byte[1024];
						while (ss > 0) {
							var chunkSize = (int)Math.Min(ss, FBuffer.Length);
							var numBytesRead = FStreamIn[0].Read(FBuffer, 0, chunkSize);
							if (numBytesRead == 0) break;
							FDataWarpOut[i].Write(FBuffer, 0, numBytesRead);
							ss -= numBytesRead;
						}
						
						//FWarpTextureOut[0].Dispose();
						//FWarpTextureOut[0] = LoadTexture(0, w, h, ind);
						//info = FWarpTextureOut[0].Metadata;
						//FWarpTextureOut[0] = FWarpTextureOut[0];
					}
					
					
					dataString += "---------\nWARPTEXTURE\nindice:"+ind.ToString();
					dataString += "\nwidth: "+w.ToString()+"\nheight"+h.ToString();
					dataString += "\nsize: "+((w*h)*16).ToString();
					dataString += "\n---------\n";
					
					//copy data bmp
					ind += (w*h)*16;
					
					FStreamIn[0].Position = ind+2; 
					FStreamIn[0].Read(buffer, 0, 4);
					int size = (int)BitConverter.ToUInt32(buffer, 0);
					dataString += "---------\nBLENDTEXTURE(bmp)\nindice:"+ind.ToString();
					dataString += "\nsize: "+size.ToString()+"\n---------\n";
					
					if(i == FBlock[0]%textureCount){
						int ss = size;
						FStreamIn[0].Position = ind;
						FDataBlendOut[0].Position = 0;
						FDataBlendOut[0].SetLength(ss);
						byte[] FBuffer = new byte[1024];
						while (ss > 0) {
							var chunkSize = (int)Math.Min(ss, FBuffer.Length);
							var numBytesRead = FStreamIn[0].Read(FBuffer, 0, chunkSize);
							if (numBytesRead == 0) break;
							FDataBlendOut[i].Write(FBuffer, 0, numBytesRead);
							ss -= numBytesRead;
						}
					}
					
					ind += size+4484;
				}
				
				FStringData[0] = dataString;
				FSuccess[0] = true;
			}
			FDataWarpOut.Flush(true);
			FDataBlendOut.Flush(true);
		}
		
		TextureResource<Info> CreateTextureResource(int slice)
		{
			var info = new Info() { Slice = slice, Width = 1, Height = 1 };
			return TextureResource.Create(info, CreateTexture);
		}	
		
		TextureResource<Info> LoadTexture(int slice, int width, int height, int indice) 
		{
			var info = new Info() { Slice = slice, Width = width, Height = height, Indice = indice};
			return TextureResource.Create(info, CreateTexture);
		}	
		
		unsafe Texture CreateTexture(Info info, Device device)
		{
			FLogger.Log(LogType.Debug, "Create texture");
			Texture texture = TextureUtils.CreateTexture(device, Math.Max(info.Width, 1), Math.Max(info.Height, 1));
			TextureUtils.Fill32BitTexInPlace(texture, info, FillTexure);
			return texture;
		}
		
		unsafe void FillTexure(uint* data, int row, int col, int width, int height, Info info)
		{			
			byte[] buffer = new byte[4];
			FStreamIn[0].Position = info.Indice+(row*width+col)*16; 
			FStreamIn[0].Read(buffer, 0, 4);
			float f1 = (float)BitConverter.ToSingle(buffer, 0)*255;
			FStreamIn[0].Read(buffer, 0, 4);
			float f2 = (float)BitConverter.ToSingle(buffer, 0)*255;
			FStreamIn[0].Read(buffer, 0, 4);
			float f3 = (float)BitConverter.ToSingle(buffer, 0)*255;
			FStreamIn[0].Read(buffer, 0, 4);
			float f4 = (float)BitConverter.ToSingle(buffer, 0)*255;
			
			//FLogger.Log(LogType.Debug, row.ToString()+ " " +col.ToString() + " " + fr.ToString() + " " + fg.ToString() + " " + fb.ToString() + " " + fa.ToString());

			byte r = (byte) f1;
			byte g = (byte) f2;
			byte b = (byte) f3;
			byte a = (byte) f3;
			
			//a pixel is just a 32-bit unsigned int value
			uint pixel = UInt32Utils.fromARGB(a, r, g, b);
			//copy pixel into texture
			TextureUtils.SetPtrVal2D(data, pixel, row, col, width);
		}
	}
}
