//@author: vux
//@help: standard constant shader
//@tags: color
//@credits: 

//float4x4 tWVP: WORLDVIEWPROJECTION;



//float4x4 tVP : VIEWPROJECTION;
//float4x4 tW : WORLD;

Texture2D texture2d; 

SamplerState g_samLinear : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};


cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	int colorcount = 1;
};


StructuredBuffer<float4x4> sbWorld;
StructuredBuffer<float4> sbColor;

StructuredBuffer<uint> sbInds;


struct VS_IN
{
	uint ii : SV_InstanceID;
	float4 PosO : POSITION;
	float2 TexCd : TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;	
	float4 Color: TEXCOORD0;
    float2 TexCd: TEXCOORD1;
	
};

vs2ps VS(VS_IN input)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

    //position (projected)
    Out.PosWVP  = mul(input.PosO,mul(sbWorld[input.ii],tVP));
	Out.Color = sbColor[input.ii % colorcount];
    Out.TexCd = input.TexCd;// mul(input.TexCd, tTex);
    return Out;
}

vs2ps VS_Cull(VS_IN input)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
	
	uint i = sbInds[input.ii];

    //position (projected)
    Out.PosWVP  = mul(input.PosO,mul(sbWorld[i],tVP));
	Out.Color = sbColor[i % colorcount];
    Out.TexCd = input.TexCd;// mul(input.TexCd, tTex);
    return Out;
}





float4 PS_Tex(vs2ps In): SV_Target
{
    float4 col = texture2d.Sample( g_samLinear, In.TexCd) * In.Color;
	//col = mul(col,tColor);
	//col.a *= Alpha;
    return col;
}


technique10 ConstantCull
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS_Cull() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Tex() ) );
	}
}



technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Tex() ) );
	}
}




