#include "cull.fxh"
 
 
//Bounding Min Max
float3 bmin; 
float3 bmax;

//plane equations
float4 planes[6];

//Small epsilon
float epsilon = 0.01f; 

StructuredBuffer<float4x4> sbworld;
int wcnt = 1;
AppendStructuredBuffer<uint> AppendResult : BACKBUFFER;

[numthreads(64, 1, 1)]
void CS( uint3 i : SV_DispatchThreadID)
{ 
	if (i.x >= wcnt) { return; }
	BoundingBox b;
	b.bmin = bmin;
	b.bmax = bmax;
	float4x4 w = sbworld[i.x];	
	if (ViewFrustumCull(b,w,planes,epsilon))
	{
		AppendResult.Append(i.x);
	}	
}

[numthreads(64, 1, 1)]
void CST( uint3 i : SV_DispatchThreadID)
{ 
	BoundingBox b;
	b.bmin = bmin;
	b.bmax = bmax;
	
	float4x4 w = transpose(sbworld[i.x]);
	
	if (ViewFrustumCull(b,w,planes,epsilon))
	{
		AppendResult.Append(i.x);
	}
	
}


technique11 Process
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS() ) );
	}
}

technique11 ProcessTranspose
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CST() ) );
	}
}








