float4x4 tW : WORLD;
float4x4 tWV : WORLDVIEW;
float4x4 tVP : VIEWPROJECTION;
float4x4 tWVP: WORLDVIEWPROJECTION;

float2 scale;
float2 offset;

#define PI 3.14159265f

#define HALFPI PI * 0.5f
#define TWOPI PI * 2.0f

//Interfaces and Classes definitions

interface iUVSpace
{
   float4 Get(float4 p);
};

interface iUVMap
{
   float2 GetUV(float4 p,float2 uv);
};

class cObjectUVSpace : iUVSpace
{
  float4 Get(float4 p)
	{
		return p;
	}
}; 

class cWorldUVSpace : iUVSpace
{
  float4 Get(float4 p)
	{
		return mul(p,tW);
	}
};


class cViewUVSpace : iUVSpace
{
  float4 Get(float4 p)
	{
		return mul(p,tWV);
	}
};

cObjectUVSpace objectuvspace;
cWorldUVSpace worlduvspace;
cViewUVSpace viewuvspace;

class cStandardUV : iUVMap
{
   float2 GetUV(float4 p,float2 uv)
	{
		return uv;
	}
}; 

class cPlanarXYUV : iUVMap
{
   float2 GetUV(float4 p,float2 uv) { return p.xy * scale + offset; }
}; 

class cPlanarXZUV : iUVMap
{
   float2 GetUV(float4 p,float2 uv) { return p.xz * scale + offset; }
}; 

class cPlanarYZUV : iUVMap
{
   float2 GetUV(float4 p,float2 uv) { return p.yz  * scale + offset; }
};

class cPerspectiveUV : iUVMap
{
   float2 GetUV(float4 p,float2 uv) 
	{
		float4 wvp = mul(p,tWVP);
		return (wvp.xy / wvp.w)  * scale + offset;
	}
}; 

cStandardUV standard;
cPlanarXYUV planarxy;
cPlanarXZUV planarxz;
cPlanarYZUV planaryz;
cPerspectiveUV perspective;

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};


Texture2D texture1; 
iUVSpace space <string linkclass="objectuvspace,worlduvspace,viewuvspace";>;
iUVMap uvmap <string linkclass="standard,planarxy,planarxz,planaryz,perspective";>;

float alpha1;

struct VS_IN
{
	float4 PosO : POSITION;
	float3 NormO : NORMAL;
	float2 TexCd : TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float2 TexCd: TEXCOORD0;
};

struct vs2psPP
{
    float4 PosWVP: SV_POSITION;
    float2 TexCd: TEXCOORD0;
	float4 P: TEXCOORD1;
};

vs2psPP VS_PP(VS_IN input)
{
    vs2psPP Out = (vs2psPP)0;

    Out.PosWVP  = mul(input.PosO, tWVP);
    Out.TexCd = input.TexCd;
    Out.P = space.Get(input.PosO);
	return Out;
} 

vs2ps VS_PV(VS_IN input)
{
    vs2ps Out = (vs2ps)0;
	
	float4 p = space.Get(input.PosO);
    Out.PosWVP  = mul(input.PosO, tWVP);
 	Out.TexCd = uvmap.GetUV(p,input.TexCd);
    return Out;
} 

float4 PS_PV(vs2ps In): SV_Target
{
	float4 col1 = texture1.Sample( g_samLinear, In.TexCd);
	return col1;
}


float4 PS_PP(vs2psPP In): SV_Target
{
	float2 uv = uvmap.GetUV(In.P,In.TexCd);
	float4 col1 = texture1.Sample( g_samLinear, uv);
	return col1;
}





technique11 PerVertexUV
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_5_0, VS_PV() ) );
		SetPixelShader( CompileShader( ps_5_0, PS_PV() ) );
	} 
}

technique11 PerPixelUV
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_5_0, VS_PP() ) );
		SetPixelShader( CompileShader( ps_5_0, PS_PP() ) );
	} 
}



