float4x4 tW : WORLD;
float4x4 tVP : VIEWPROJECTION;

float Alpha <float uimin=0.0; float uimax=1.0;> = 1;
float4 cNoHit < bool color=true;> = { 0.0f,1.0f,0.0f,1.0f };
float4 cHit < bool color=true;> = { 1.0f,0.0f,0.0f,1.0f };

float3 raypos;
float3 raydir;

struct vsin
{
	float4 pos : POSITION;
	float4 uv : TEXCOORD0;
};

struct vs2gs
{
    float4 pos : POSITION;
	float4 uv : TEXCOORD0;
};

struct gs2ps
{
    float4 pos: SV_POSITION;
    float4 color: COLOR0;
	float4 uv : TEXCOORD0;
};

vs2gs VS(vsin input)
{
	vs2gs output;
	output.pos = mul(input.pos,tW);
	output.uv = input.uv;

    return output;
}

float eps : EPSILON = 0.000001f;

[maxvertexcount(3)]
void GS(triangle vs2gs input[3], inout TriangleStream<gs2ps> gsout)
{
	gs2ps o;
	
	float3 diff = raypos - input[0].pos.xyz;
	float3 faceEdgeA = input[1].pos.xyz - input[0].pos.xyz;
    float3 faceEdgeB = input[2].pos.xyz - input[0].pos.xyz;
    
	float3 norm = cross(faceEdgeB, faceEdgeA);
	//norm = normalize(norm);
	
	//Ray/Trangle intersection, from 
	// www.geometrictools.com
	
	float DdN = dot(raydir,norm);
    float fsign;
	
	bool hit = true;
	
    if (DdN > eps)
    {
        fsign = 1.0f;
    }
    else if (eps)
    {
        fsign = -1.0;
        DdN = -DdN;
    }
    else
    {
        hit = false;
    }
	
	
	if (hit)
	{
		hit = false;
		float DdQxE2 = fsign*dot(raydir, cross(faceEdgeB,diff));
		if (DdQxE2 >= 0.0f)
	    {
	    	float DdE1xQ = fsign*dot(raydir,cross(diff,faceEdgeA)); 
	        if (DdE1xQ >= 0.0f)
	        {
	            if (DdQxE2 + DdE1xQ <= DdN)
	            {
	                // Line intersects triangle, check if ray does.
	                float QdN = -fsign* dot(diff,norm);
	                if (QdN >= 0.0f)
	                {
	                    hit = true;
	                }
	            }
	        }
	    }
	}
	
	
	
	o.color = hit ? cHit : cNoHit;
	
	o.pos = mul(input[0].pos,tVP);
	o.uv = input[0].uv;
	gsout.Append(o);
	
	o.pos = mul(input[1].pos,tVP);
	o.uv = input[1].uv;
	gsout.Append(o);
	
	o.pos = mul(input[2].pos,tVP);
	o.uv = input[2].uv;
	gsout.Append(o);
}

float4 PS(gs2ps input): SV_Target
{
    return input.color* sqrt(dot(input.uv,input.uv)) *0.5f;
}

technique10 Constant
{
	pass P0
	{
		SetHullShader( 0 );
		SetDomainShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetGeometryShader( CompileShader( gs_4_0, GS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}





