//@author: vux
//@help: standard constant shader
//@tags: color
//@credits: 

float4x4 tWVP: WORLDVIEWPROJECTION;
float4 cAmb <bool color=true;>;

Texture2D texture2d; 

static const int MAXMAT = 60;
float4x4 SkinningMatrices[MAXMAT];

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

SamplerState g_samWrap
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
	AddressW = Wrap;
};


struct vsInput
{
	float4 PosO : POSITION;
	float3 Normal : NORMAL;
	float4 BlendWeights	: BLENDWEIGHT;
	float4 BlendIndices : BLENDINDICES;
	float2 TexCd: TEXCOORD0;
};


struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float2 TexCd: TEXCOORD0;
};

vs2ps VS_D(vsInput input)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
	
	float4 blendWeights = input.BlendWeights;
	blendWeights.w = 1.0f - dot( blendWeights.xyz, float3( 1, 1, 1));
	int4 indices = input.BlendIndices;
	
	float4 pos =0;
	float3 norm = 0;
	
	pos = pos + mul(input.PosO,SkinningMatrices[indices.x]) * blendWeights.x;
    pos = pos + mul(input.PosO,SkinningMatrices[indices.y]) * blendWeights.y;
	pos = pos + mul(input.PosO,SkinningMatrices[indices.z]) * blendWeights.z;
    pos = pos + mul(input.PosO,SkinningMatrices[indices.w]) * blendWeights.w;
    
  	norm = norm + mul(input.Normal,SkinningMatrices[indices.x]) * blendWeights.x;
    norm = norm + mul(input.Normal,SkinningMatrices[indices.y]) * blendWeights.y;
	norm = norm + mul(input.Normal,SkinningMatrices[indices.z]) * blendWeights.z;
    norm = norm + mul(input.Normal,SkinningMatrices[indices.w]) * blendWeights.w;
      	
	norm = normalize(norm);

    //position (projected)
    Out.PosWVP  = mul(pos, tWVP);
    Out.TexCd = input.TexCd;
    return Out;
}


float4 PS(vs2ps In): SV_Target
{
    float4 col = texture2d.Sample(g_samLinear,In.TexCd);
	col *= cAmb;
    return col;
}



technique10 Render
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS_D() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}







